;;;============================================================================

;;; File: "gambit#.scm", Time-stamp: <2008-05-23 14:47:10 feeley>

;;; Copyright (c) 2005-2008 by Marc Feeley, All Rights Reserved.

;;;============================================================================

;; Identifiers bound to syntactic forms and procedures defined by Gambit
;; are mapped to the empty namespace (no prefix).

(##include "~~/lib/r5rs#.scm") ;; most identifier bindings are inherited from R5RS

(##namespace ("" ;; these identifier bindings are specific to Gambit

;; special forms
define-record-type
define-structure
define-type
define-type-of-thread
c-define-type
c-declare
c-initialize
c-lambda
c-define
define-macro
;;define-syntax
include
declare
namespace
this-source-file
parameterize
receive
time
cond-expand
define-cond-expand-feature

six.!x
six.&x
six.*x
six.++x
six.+x
six.--x
six.-x
six.arrow
six.call
six.compound
six.cons
six.define-procedure
six.define-variable
six.do-while
six.dot
six.for
six.identifier
six.if
six.index
six.list
six.literal
six.new
six.null
six.prefix
six.procedure
six.procedure-body
six.while
six.x!=y
six.x%=y
six.x%y
six.x&&y
six.x&=y
six.x&y
six.x*=y
six.x*y
six.x++
six.x+=y
six.x+y
|six.x,y|
six.x--
six.x-=y
six.x-y
six.x/=y
six.x/y
six.x:=y
six.x:y
six.x<<=y
six.x<<y
six.x<=y
six.x<y
six.x==y
six.x=y
six.x>=y
six.x>>=y
six.x>>y
six.x>y
six.x?y:z
six.x^=y
six.x^y
|six.x\|=y|
|six.x\|\|y|
|six.x\|y|
six.~x

six.!
six.break
six.case
six.clause
six.continue
six.goto
six.label
six.return
six.switch
six.x:-y

;; procedures (TODO: check consistency with release, remove stuff in r5rs)

;; this code produces the list of procedures
#;
(let ()

  (define (keep keep? lst)
    (cond ((null? lst)       '())
          ((keep? (car lst)) (cons (car lst) (keep keep? (cdr lst))))
          (else              (keep keep? (cdr lst)))))

  (define (sort-list lst <?)

    (define (mergesort lst)

      (define (merge lst1 lst2)
        (cond ((null? lst1) lst2)
              ((null? lst2) lst1)
              (else
               (let ((e1 (car lst1)) (e2 (car lst2)))
                 (if (<? e1 e2)
                     (cons e1 (merge (cdr lst1) lst2))
                     (cons e2 (merge lst1 (cdr lst2))))))))

      (define (split lst)
        (if (or (null? lst) (null? (cdr lst)))
            lst
            (cons (car lst) (split (cddr lst)))))

      (if (or (null? lst) (null? (cdr lst)))
          lst
          (let* ((lst1 (mergesort (split lst)))
                 (lst2 (mergesort (split (cdr lst)))))
            (merge lst1 lst2))))

    (mergesort lst))

  (define (symbol-table->list st)
    (apply append
           (map (lambda (s)
                  (let loop ((s s) (lst '()))
                    (if (symbol? s)
                        (loop (##vector-ref s 2) (cons s lst))
                        (reverse lst))))
                (vector->list st))))

  (define (public-procedure? s)
    (if (let ((str (symbol->string s)))
          (or (and (>= (string-length str) 2)
                   (equal? (substring str 0 2) "##"))
              (and (>= (string-length str) 1)
                   (equal? (substring str 0 1) " "))))
              
        #f
        (let ((val (##global-var-ref (##make-global-var s))))
          (procedure? val))))

  (for-each
   pp
   (sort-list
    (keep public-procedure?
          (symbol-table->list (##symbol-table)))
    (lambda (x y) (string<? (symbol->string x) (symbol->string y))))))

*
+
-
/
<
<=
=
>
>=
abandoned-mutex-exception?
abort
abs
acos
all-bits-set?
angle
any-bits-set?
append
apply
arithmetic-shift
asin
assoc
assq
assv
atan
bit-count
bit-set?
bitwise-and
bitwise-ior
bitwise-merge
bitwise-not
bitwise-xor
boolean?
box
box?
break
caaaar
caaadr
caaar
caadar
caaddr
caadr
caar
cadaar
cadadr
cadar
caddar
cadddr
caddr
cadr
call-with-current-continuation
call-with-input-file
call-with-input-string
call-with-input-u8vector
call-with-input-vector
call-with-output-file
call-with-output-string
call-with-output-u8vector
call-with-output-vector
call-with-values
call/cc
car
cdaaar
cdaadr
cdaar
cdadar
cdaddr
cdadr
cdar
cddaar
cddadr
cddar
cdddar
cddddr
cdddr
cddr
cdr
ceiling
cfun-conversion-exception-arguments
cfun-conversion-exception-code
cfun-conversion-exception-message
cfun-conversion-exception-procedure
cfun-conversion-exception?
char->integer
char-alphabetic?
char-ci<=?
char-ci<?
char-ci=?
char-ci>=?
char-ci>?
char-downcase
char-lower-case?
char-numeric?
char-ready?
char-upcase
char-upper-case?
char-whitespace?
char<=?
char<?
char=?
char>=?
char>?
char?
clear-bit-field
close-input-port
close-output-port
close-port
command-line
compile-file
compile-file-to-c
complex?
condition-variable-broadcast!
condition-variable-name
condition-variable-signal!
condition-variable-specific
condition-variable-specific-set!
condition-variable?
cons
console-port
continuation-capture
continuation-graft
continuation-return
copy-bit-field
copy-file
cos
cpu-time
create-directory
create-fifo
create-link
create-symbolic-link
current-directory
current-error-port
current-exception-handler
current-input-port
current-output-port
current-readtable
current-thread
current-time
current-user-interrupt-handler
datum-parsing-exception-kind
datum-parsing-exception-parameters
datum-parsing-exception-readenv
datum-parsing-exception?
deadlock-exception?
defer-user-interrupts
delete-directory
delete-file
denominator
directory-files
display
display-continuation-backtrace
display-continuation-dynamic-environment
display-continuation-environment
display-environment-set!
display-exception
display-exception-in-context
display-procedure-environment
divide-by-zero-exception-arguments
divide-by-zero-exception-procedure
divide-by-zero-exception?
dynamic-wind
eof-object?
eq?
eq?-hash
equal?
equal?-hash
eqv?
eqv?-hash
err-code->string
error
error-exception-message
error-exception-parameters
error-exception?
eval
even?
exact->inexact
exact?
exit
exp
expression-parsing-exception-kind
expression-parsing-exception-parameters
expression-parsing-exception-source
expression-parsing-exception?
expt
extract-bit-field
f32vector
f32vector->list
f32vector-append
f32vector-copy
f32vector-fill!
f32vector-length
f32vector-ref
f32vector-set!
f32vector?
f64vector
f64vector->list
f64vector-append
f64vector-copy
f64vector-fill!
f64vector-length
f64vector-ref
f64vector-set!
f64vector?
file-attributes
file-creation-time
file-device
file-exists?
file-group
file-info
file-info-attributes
file-info-creation-time
file-info-device
file-info-group
file-info-inode
file-info-last-access-time
file-info-last-change-time
file-info-last-modification-time
file-info-mode
file-info-number-of-links
file-info-owner
file-info-size
file-info-type
file-info?
file-inode
file-last-access-time
file-last-change-time
file-last-modification-time
file-mode
file-number-of-links
file-owner
file-size
file-type
finite?
first-bit-set
fixnum->flonum
fixnum-overflow-exception-arguments
fixnum-overflow-exception-procedure
fixnum-overflow-exception?
fixnum?
fl*
fl+
fl-
fl/
fl<
fl<=
fl=
fl>
fl>=
flabs
flacos
flasin
flatan
flceiling
flcos
fldenominator
fleven?
flexp
flexpt
flfinite?
flfloor
flinfinite?
flinteger?
fllog
flmax
flmin
flnan?
flnegative?
flnumerator
flodd?
flonum?
floor
flpositive?
flround
flsin
flsqrt
fltan
fltruncate
flzero?
for-each
force
force-output
foreign-address
foreign-release!
foreign-released?
foreign-tags
foreign?
fx*
fx+
fx-
fx<
fx<=
fx=
fx>
fx>=
fxand
fxarithmetic-shift
fxarithmetic-shift-left
fxarithmetic-shift-right
fxbit-count
fxbit-set?
fxeven?
fxfirst-bit-set
fxif
fxior
fxlength
fxmax
fxmin
fxmodulo
fxnegative?
fxnot
fxodd?
fxpositive?
fxquotient
fxremainder
fxwrap*
fxwrap+
fxwrap-
fxwraparithmetic-shift
fxwraparithmetic-shift-left
fxwraplogical-shift-right
fxwrapquotient
fxxor
fxzero?
gc-report-set!
gcd
generate-proper-tail-calls
gensym
get-output-string
get-output-u8vector
get-output-vector
getenv
group-info
group-info-gid
group-info-members
group-info-name
group-info?
heap-overflow-exception?
host-info
host-info-addresses
host-info-aliases
host-info-name
host-info?
host-name
imag-part
improper-length-list-exception-arg-num
improper-length-list-exception-arguments
improper-length-list-exception-procedure
improper-length-list-exception?
inexact->exact
inexact?
infinite?
initialized-thread-exception-arguments
initialized-thread-exception-procedure
initialized-thread-exception?
input-port-byte-position
input-port-bytes-buffered
input-port-char-position
input-port-characters-buffered
input-port-column
input-port-line
input-port-readtable
input-port-readtable-set!
input-port-timeout-set!
input-port?
integer->char
integer-length
integer-nth-root
integer-sqrt
integer?
interaction-environment
invalid-hash-number-exception-arguments
invalid-hash-number-exception-procedure
invalid-hash-number-exception?
join-timeout-exception-arguments
join-timeout-exception-procedure
join-timeout-exception?
keyword->string
keyword-expected-exception-arguments
keyword-expected-exception-procedure
keyword-expected-exception?
keyword-hash
keyword?
lcm
length
link-flat
link-incremental
list
list->f32vector
list->f64vector
list->s16vector
list->s32vector
list->s64vector
list->s8vector
list->string
list->table
list->u16vector
list->u32vector
list->u64vector
list->u8vector
list->vector
list-ref
list-tail
list?
load
log
magnitude
mailbox-receive-timeout-exception-arguments
mailbox-receive-timeout-exception-procedure
mailbox-receive-timeout-exception?
main
make-condition-variable
make-f32vector
make-f64vector
make-mutex
make-parameter
make-polar
make-random-source
make-rectangular
make-s16vector
make-s32vector
make-s64vector
make-s8vector
make-string
make-table
make-thread
make-thread-group
make-u16vector
make-u32vector
make-u64vector
make-u8vector
make-uninterned-keyword
make-uninterned-symbol
make-vector
make-will
map
max
member
memq
memv
min
modulo
multiple-c-return-exception?
mutex-lock!
mutex-name
mutex-specific
mutex-specific-set!
mutex-state
mutex-unlock!
mutex?
nan?
negative?
network-info
network-info-aliases
network-info-name
network-info-net
network-info?
newline
no-such-file-or-directory-exception-arguments
no-such-file-or-directory-exception-procedure
no-such-file-or-directory-exception?
noncontinuable-exception-reason
noncontinuable-exception?
nonempty-input-port-character-buffer-exception-arguments
nonempty-input-port-character-buffer-exception-procedure
nonempty-input-port-character-buffer-exception?
nonprocedure-operator-exception-arguments
nonprocedure-operator-exception-code
nonprocedure-operator-exception-operator
nonprocedure-operator-exception-rte
nonprocedure-operator-exception?
not
null-environment
null?
number->string
number-of-arguments-limit-exception-arguments
number-of-arguments-limit-exception-procedure
number-of-arguments-limit-exception?
number?
numerator
object->serial-number
object->string
object->u8vector
odd?
open-directory
open-dummy
open-event-queue
open-file
open-input-file
open-input-string
open-input-u8vector
open-input-vector
open-output-file
open-output-string
open-output-u8vector
open-output-vector
open-process
open-string
open-string-pipe
open-tcp-client
open-tcp-server
open-u8vector
open-u8vector-pipe
open-vector
open-vector-pipe
os-exception-arguments
os-exception-code
os-exception-message
os-exception-procedure
os-exception?
output-port-byte-position
output-port-char-position
output-port-column
output-port-line
output-port-readtable
output-port-readtable-set!
output-port-timeout-set!
output-port-width
output-port?
pair?
path-directory
path-expand
path-extension
path-normalize
path-strip-directory
path-strip-extension
path-strip-trailing-directory-separator
path-strip-volume
path-volume
peek-char
port-settings-set!
port?
positive?
pp
pretty-print
primordial-exception-handler
print
println
procedure?
process-pid
process-status
process-times
protocol-info
protocol-info-aliases
protocol-info-name
protocol-info-number
protocol-info?
quotient
raise
random-integer
random-real
random-source-make-integers
random-source-make-reals
random-source-pseudo-randomize!
random-source-randomize!
random-source-state-ref
random-source-state-set!
random-source?
range-exception-arg-num
range-exception-arguments
range-exception-procedure
range-exception?
rational?
rationalize
read
read-all
read-char
read-line
read-substring
read-subu8vector
read-u8
readtable-case-conversion?
readtable-case-conversion?-set
readtable-eval-allowed?
readtable-eval-allowed?-set
readtable-keywords-allowed?
readtable-keywords-allowed?-set
readtable-max-unescaped-char
readtable-max-unescaped-char-set
readtable-max-write-length
readtable-max-write-length-set
readtable-max-write-level
readtable-max-write-level-set
readtable-sharing-allowed?
readtable-sharing-allowed?-set
readtable-start-syntax
readtable-start-syntax-set
readtable?
real-part
real-time
real?
remainder
rename-file
repl-backtrace-display-environment?
repl-display-dynamic-environment?
repl-input-port
repl-output-port
repl-result-history-max-length-set!
repl-result-history-ref
replace-bit-field
reverse
round
s16vector
s16vector->list
s16vector-append
s16vector-copy
s16vector-fill!
s16vector-length
s16vector-ref
s16vector-set!
s16vector?
s32vector
s32vector->list
s32vector-append
s32vector-copy
s32vector-fill!
s32vector-length
s32vector-ref
s32vector-set!
s32vector?
s64vector
s64vector->list
s64vector-append
s64vector-copy
s64vector-fill!
s64vector-length
s64vector-ref
s64vector-set!
s64vector?
s8vector
s8vector->list
s8vector-append
s8vector-copy
s8vector-fill!
s8vector-length
s8vector-ref
s8vector-set!
s8vector?
scheduler-exception-reason
scheduler-exception?
scheme-report-environment
seconds->time
serial-number->object
service-info
service-info-aliases
service-info-name
service-info-port
service-info-protocol
service-info?
set-box!
set-car!
set-cdr!
setenv
sfun-conversion-exception-arguments
sfun-conversion-exception-code
sfun-conversion-exception-message
sfun-conversion-exception-procedure
sfun-conversion-exception?
shell-command
shell-command-blocking
sin
six.make-array
socket-info-address
socket-info-family
socket-info-port-number
socket-info?
sqrt
stack-overflow-exception?
started-thread-exception-arguments
started-thread-exception-procedure
started-thread-exception?
step
step-level-set!
string
string->keyword
string->list
string->number
string->symbol
string-append
string-ci<=?
string-ci<?
string-ci=?
string-ci=?-hash
string-ci>=?
string-ci>?
string-copy
string-fill!
string-length
string-ref
string-set!
string<=?
string<?
string=?
string=?-hash
string>=?
string>?
string?
subf32vector
subf64vector
subs16vector
subs32vector
subs64vector
subs8vector
substring
subu16vector
subu32vector
subu64vector
subu8vector
subvector
symbol->string
symbol-hash
symbol?
system-stamp
system-type
system-type-string
system-version
system-version-string
table->list
table-copy
table-for-each
table-length
table-merge
table-merge!
table-ref
table-search
table-set!
table?
tan
tcp-client-peer-socket-info
tcp-client-self-socket-info
tcp-server-socket-info
terminated-thread-exception-arguments
terminated-thread-exception-procedure
terminated-thread-exception?
test-bit-field?
thread-base-priority
thread-base-priority-set!
thread-group->thread-group-list
thread-group->thread-group-vector
thread-group->thread-list
thread-group->thread-vector
thread-group-name
thread-group-parent
thread-group-resume!
thread-group-suspend!
thread-group-terminate!
thread-group?
thread-init!
thread-join!
thread-mailbox-extract-and-rewind
thread-mailbox-next
thread-mailbox-rewind
thread-name
thread-priority-boost
thread-priority-boost-set!
thread-quantum
thread-quantum-set!
thread-receive
thread-resume!
thread-send
thread-sleep!
thread-specific
thread-specific-set!
thread-start!
thread-suspend!
thread-terminate!
thread-thread-group
thread-yield!
thread?
time->seconds
time?
timeout->time
touch
trace
transcript-off
transcript-on
truncate
tty-history
tty-history-max-length-set!
tty-history-set!
tty-mode-set!
tty-paren-balance-duration-set!
tty-text-attributes-set!
tty-type-set!
tty?
type-exception-arg-num
type-exception-arguments
type-exception-procedure
type-exception-type-id
type-exception?
u16vector
u16vector->list
u16vector-append
u16vector-copy
u16vector-fill!
u16vector-length
u16vector-ref
u16vector-set!
u16vector?
u32vector
u32vector->list
u32vector-append
u32vector-copy
u32vector-fill!
u32vector-length
u32vector-ref
u32vector-set!
u32vector?
u64vector
u64vector->list
u64vector-append
u64vector-copy
u64vector-fill!
u64vector-length
u64vector-ref
u64vector-set!
u64vector?
u8vector
u8vector->list
u8vector->object
u8vector-append
u8vector-copy
u8vector-fill!
u8vector-length
u8vector-ref
u8vector-set!
u8vector?
unbound-global-exception-code
unbound-global-exception-rte
unbound-global-exception-variable
unbound-global-exception?
unbound-os-environment-variable-exception-arguments
unbound-os-environment-variable-exception-procedure
unbound-os-environment-variable-exception?
unbound-serial-number-exception-arguments
unbound-serial-number-exception-procedure
unbound-serial-number-exception?
unbound-table-key-exception-arguments
unbound-table-key-exception-procedure
unbound-table-key-exception?
unbox
unbreak
uncaught-exception-arguments
uncaught-exception-procedure
uncaught-exception-reason
uncaught-exception?
uninitialized-thread-exception-arguments
uninitialized-thread-exception-procedure
uninitialized-thread-exception?
uninterned-keyword?
uninterned-symbol?
unknown-keyword-argument-exception-arguments
unknown-keyword-argument-exception-procedure
unknown-keyword-argument-exception?
unterminated-process-exception-arguments
unterminated-process-exception-procedure
unterminated-process-exception?
untrace
user-info
user-info-gid
user-info-home
user-info-name
user-info-shell
user-info-uid
user-info?
user-name
values
vector
vector->list
vector-append
vector-copy
vector-fill!
vector-length
vector-ref
vector-set!
vector?
void
will-execute!
will-testator
will?
with-exception-catcher
with-exception-handler
with-input-from-file
with-input-from-port
with-input-from-string
with-input-from-u8vector
with-input-from-vector
with-output-to-file
with-output-to-port
with-output-to-string
with-output-to-u8vector
with-output-to-vector
write
write-char
write-substring
write-subu8vector
write-u8
wrong-number-of-arguments-exception-arguments
wrong-number-of-arguments-exception-procedure
wrong-number-of-arguments-exception?
zero?

))

;;;============================================================================
