// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Information about a Savings Plan offering.
type ParentSavingsPlanOffering struct {

	// The currency.
	Currency CurrencyCode

	// The duration, in seconds.
	DurationSeconds int64

	// The ID of the offering.
	OfferingId *string

	// The payment option.
	PaymentOption SavingsPlanPaymentOption

	// The description.
	PlanDescription *string

	// The plan type.
	PlanType SavingsPlanType

	noSmithyDocumentSerde
}

// Information about a Savings Plan.
type SavingsPlan struct {

	// The hourly commitment, in USD.
	Commitment *string

	// The currency.
	Currency CurrencyCode

	// The description.
	Description *string

	// The EC2 instance family.
	Ec2InstanceFamily *string

	// The end time.
	End *string

	// The ID of the offering.
	OfferingId *string

	// The payment option.
	PaymentOption SavingsPlanPaymentOption

	// The product types.
	ProductTypes []SavingsPlanProductType

	// The recurring payment amount.
	RecurringPaymentAmount *string

	// The AWS Region.
	Region *string

	// The Amazon Resource Name (ARN) of the Savings Plan.
	SavingsPlanArn *string

	// The ID of the Savings Plan.
	SavingsPlanId *string

	// The plan type.
	SavingsPlanType SavingsPlanType

	// The start time.
	Start *string

	// The state.
	State SavingsPlanState

	// One or more tags.
	Tags map[string]string

	// The duration of the term, in seconds.
	TermDurationInSeconds int64

	// The up-front payment amount.
	UpfrontPaymentAmount *string

	noSmithyDocumentSerde
}

// Information about a filter.
type SavingsPlanFilter struct {

	// The filter name.
	Name SavingsPlansFilterName

	// The filter value.
	Values []string

	noSmithyDocumentSerde
}

// Information about a Savings Plan offering.
type SavingsPlanOffering struct {

	// The currency.
	Currency CurrencyCode

	// The description.
	Description *string

	// The duration, in seconds.
	DurationSeconds int64

	// The ID of the offering.
	OfferingId *string

	// The specific AWS operation for the line item in the billing report.
	Operation *string

	// The payment option.
	PaymentOption SavingsPlanPaymentOption

	// The plan type.
	PlanType SavingsPlanType

	// The product type.
	ProductTypes []SavingsPlanProductType

	// The properties.
	Properties []SavingsPlanOfferingProperty

	// The service.
	ServiceCode *string

	// The usage details of the line item in the billing report.
	UsageType *string

	noSmithyDocumentSerde
}

// Information about a filter.
type SavingsPlanOfferingFilterElement struct {

	// The filter name.
	Name SavingsPlanOfferingFilterAttribute

	// The filter values.
	Values []string

	noSmithyDocumentSerde
}

// Information about a property.
type SavingsPlanOfferingProperty struct {

	// The property name.
	Name SavingsPlanOfferingPropertyKey

	// The property value.
	Value *string

	noSmithyDocumentSerde
}

// Information about a Savings Plan offering rate.
type SavingsPlanOfferingRate struct {

	// The specific AWS operation for the line item in the billing report.
	Operation *string

	// The product type.
	ProductType SavingsPlanProductType

	// The properties.
	Properties []SavingsPlanOfferingRateProperty

	// The Savings Plan rate.
	Rate *string

	// The Savings Plan offering.
	SavingsPlanOffering *ParentSavingsPlanOffering

	// The service.
	ServiceCode SavingsPlanRateServiceCode

	// The unit.
	Unit SavingsPlanRateUnit

	// The usage details of the line item in the billing report.
	UsageType *string

	noSmithyDocumentSerde
}

// Information about a filter.
type SavingsPlanOfferingRateFilterElement struct {

	// The filter name.
	Name SavingsPlanRateFilterAttribute

	// The filter values.
	Values []string

	noSmithyDocumentSerde
}

// Information about a property.
type SavingsPlanOfferingRateProperty struct {

	// The property name.
	Name *string

	// The property value.
	Value *string

	noSmithyDocumentSerde
}

// Information about a Savings Plan rate.
type SavingsPlanRate struct {

	// The currency.
	Currency CurrencyCode

	// The specific AWS operation for the line item in the billing report.
	Operation *string

	// The product type.
	ProductType SavingsPlanProductType

	// The properties.
	Properties []SavingsPlanRateProperty

	// The rate.
	Rate *string

	// The service.
	ServiceCode SavingsPlanRateServiceCode

	// The unit.
	Unit SavingsPlanRateUnit

	// The usage details of the line item in the billing report.
	UsageType *string

	noSmithyDocumentSerde
}

// Information about a filter.
type SavingsPlanRateFilter struct {

	// The filter name.
	Name SavingsPlanRateFilterName

	// The filter values.
	Values []string

	noSmithyDocumentSerde
}

// Information about a property.
type SavingsPlanRateProperty struct {

	// The property name.
	Name SavingsPlanRatePropertyKey

	// The property value.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
