// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package firehose provides a client for Amazon Kinesis Firehose.
package firehose

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateDeliveryStream = "CreateDeliveryStream"

// CreateDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeliveryStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDeliveryStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDeliveryStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDeliveryStreamRequest method.
//    req, resp := client.CreateDeliveryStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Firehose) CreateDeliveryStreamRequest(input *CreateDeliveryStreamInput) (req *request.Request, output *CreateDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opCreateDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeliveryStreamInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeliveryStreamOutput{}
	req.Data = output
	return
}

// CreateDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Creates a delivery stream.
//
// CreateDeliveryStream is an asynchronous operation that immediately returns.
// The initial status of the delivery stream is CREATING. After the delivery
// stream is created, its status is ACTIVE and it now accepts data. Attempts
// to send data to a delivery stream that is not in the ACTIVE state cause an
// exception. To check the state of a delivery stream, use DescribeDeliveryStream.
//
// The name of a delivery stream identifies it. You can't have two delivery
// streams with the same name in the same region. Two delivery streams in different
// AWS accounts or different regions in the same AWS account can have the same
// name.
//
// By default, you can create up to 20 delivery streams per region.
//
// A delivery stream can only be configured with a single destination, Amazon
// S3, Amazon Elasticsearch Service, or Amazon Redshift. For correct CreateDeliveryStream
// request syntax, specify only one destination configuration parameter: either
// S3DestinationConfiguration, ElasticsearchDestinationConfiguration, or RedshiftDestinationConfiguration.
//
// As part of S3DestinationConfiguration, optional values BufferingHints, EncryptionConfiguration,
// and CompressionFormat can be provided. By default, if no BufferingHints value
// is provided, Firehose buffers data up to 5 MB or for 5 minutes, whichever
// condition is satisfied first. Note that BufferingHints is a hint, so there
// are some cases where the service cannot adhere to these conditions strictly;
// for example, record boundaries are such that the size is a little over or
// under the configured buffering size. By default, no encryption is performed.
// We strongly recommend that you enable encryption to ensure secure data storage
// in Amazon S3.
//
// A few notes about RedshiftDestinationConfiguration:
//
//    * An Amazon Redshift destination requires an S3 bucket as intermediate
//    location, as Firehose first delivers data to S3 and then uses COPY syntax
//    to load data into an Amazon Redshift table. This is specified in the RedshiftDestinationConfiguration.S3Configuration
//    parameter element.
//
//    * The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration
//    because the Amazon Redshift COPY operation that reads from the S3 bucket
//    doesn't support these compression formats.
//
//    * We strongly recommend that the username and password provided is used
//    exclusively for Firehose purposes, and that the permissions for the account
//    are restricted for Amazon Redshift INSERT permissions.
//
// Firehose assumes the IAM role that is configured as part of destinations.
// The IAM role should allow the Firehose principal to assume the role, and
// the role should have permissions that allows the service to deliver the data.
// For more information, see Amazon S3 Bucket Access (http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3)
// in the Amazon Kinesis Firehose Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation CreateDeliveryStream for usage and error information.
//
// Returned Error Codes:
//   * InvalidArgumentException
//   The specified input parameter has an value that is not valid.
//
//   * LimitExceededException
//   You have already reached the limit for a requested resource.
//
//   * ResourceInUseException
//   The resource is already in use and not available for this operation.
//
func (c *Firehose) CreateDeliveryStream(input *CreateDeliveryStreamInput) (*CreateDeliveryStreamOutput, error) {
	req, out := c.CreateDeliveryStreamRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDeliveryStream = "DeleteDeliveryStream"

// DeleteDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeliveryStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDeliveryStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDeliveryStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDeliveryStreamRequest method.
//    req, resp := client.DeleteDeliveryStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Firehose) DeleteDeliveryStreamRequest(input *DeleteDeliveryStreamInput) (req *request.Request, output *DeleteDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryStreamInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDeliveryStreamOutput{}
	req.Data = output
	return
}

// DeleteDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Deletes a delivery stream and its data.
//
// You can delete a delivery stream only if it is in ACTIVE or DELETING state,
// and not in the CREATING state. While the deletion request is in process,
// the delivery stream is in the DELETING state.
//
// To check the state of a delivery stream, use DescribeDeliveryStream.
//
// While the delivery stream is DELETING state, the service may continue to
// accept the records, but the service doesn't make any guarantees with respect
// to delivering the data. Therefore, as a best practice, you should first stop
// any applications that are sending records before deleting a delivery stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation DeleteDeliveryStream for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUseException
//   The resource is already in use and not available for this operation.
//
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
func (c *Firehose) DeleteDeliveryStream(input *DeleteDeliveryStreamInput) (*DeleteDeliveryStreamOutput, error) {
	req, out := c.DeleteDeliveryStreamRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDeliveryStream = "DescribeDeliveryStream"

// DescribeDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDeliveryStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDeliveryStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDeliveryStreamRequest method.
//    req, resp := client.DescribeDeliveryStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Firehose) DescribeDeliveryStreamRequest(input *DescribeDeliveryStreamInput) (req *request.Request, output *DescribeDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryStreamInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDeliveryStreamOutput{}
	req.Data = output
	return
}

// DescribeDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Describes the specified delivery stream and gets the status. For example,
// after your delivery stream is created, call DescribeDeliveryStream to see
// if the delivery stream is ACTIVE and therefore ready for data to be sent
// to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation DescribeDeliveryStream for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
func (c *Firehose) DescribeDeliveryStream(input *DescribeDeliveryStreamInput) (*DescribeDeliveryStreamOutput, error) {
	req, out := c.DescribeDeliveryStreamRequest(input)
	err := req.Send()
	return out, err
}

const opListDeliveryStreams = "ListDeliveryStreams"

// ListDeliveryStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeliveryStreams operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDeliveryStreams for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDeliveryStreams method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDeliveryStreamsRequest method.
//    req, resp := client.ListDeliveryStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Firehose) ListDeliveryStreamsRequest(input *ListDeliveryStreamsInput) (req *request.Request, output *ListDeliveryStreamsOutput) {
	op := &request.Operation{
		Name:       opListDeliveryStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeliveryStreamsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeliveryStreamsOutput{}
	req.Data = output
	return
}

// ListDeliveryStreams API operation for Amazon Kinesis Firehose.
//
// Lists your delivery streams.
//
// The number of delivery streams might be too large to return using a single
// call to ListDeliveryStreams. You can limit the number of delivery streams
// returned, using the Limit parameter. To determine whether there are more
// delivery streams to list, check the value of HasMoreDeliveryStreams in the
// output. If there are more delivery streams to list, you can request them
// by specifying the name of the last delivery stream returned in the call in
// the ExclusiveStartDeliveryStreamName parameter of a subsequent call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation ListDeliveryStreams for usage and error information.
func (c *Firehose) ListDeliveryStreams(input *ListDeliveryStreamsInput) (*ListDeliveryStreamsOutput, error) {
	req, out := c.ListDeliveryStreamsRequest(input)
	err := req.Send()
	return out, err
}

const opPutRecord = "PutRecord"

// PutRecordRequest generates a "aws/request.Request" representing the
// client's request for the PutRecord operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRecord for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRecord method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRecordRequest method.
//    req, resp := client.PutRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Firehose) PutRecordRequest(input *PutRecordInput) (req *request.Request, output *PutRecordOutput) {
	op := &request.Operation{
		Name:       opPutRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutRecordOutput{}
	req.Data = output
	return
}

// PutRecord API operation for Amazon Kinesis Firehose.
//
// Writes a single data record into an Amazon Kinesis Firehose delivery stream.
// To write multiple data records into a delivery stream, use PutRecordBatch.
// Applications using these operations are referred to as producers.
//
// By default, each delivery stream can take in up to 2,000 transactions per
// second, 5,000 records per second, or 5 MB per second. Note that if you use
// PutRecord and PutRecordBatch, the limits are an aggregate across these two
// operations for each delivery stream. For more information about limits and
// how to request an increase, see Amazon Kinesis Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// You must specify the name of the delivery stream and the data record when
// using PutRecord. The data record consists of a data blob that can be up to
// 1,000 KB in size, and any kind of data, for example, a segment from a log
// file, geographic location data, web site clickstream data, etc.
//
// Firehose buffers records before delivering them to the destination. To disambiguate
// the data blobs at the destination, a common solution is to use delimiters
// in the data, such as a newline (\n) or some other character unique within
// the data. This allows the consumer application(s) to parse individual data
// items when reading the data from the destination.
//
// The PutRecord operation returns a RecordId, which is a unique string assigned
// to each record. Producer applications can use this ID for purposes such as
// auditability and investigation.
//
// If the PutRecord operation throws a ServiceUnavailableException, back off
// and retry. If the exception persists, it is possible that the throughput
// limits have been exceeded for the delivery stream.
//
// Data records sent to Firehose are stored for 24 hours from the time they
// are added to a delivery stream as it attempts to send the records to the
// destination. If the destination is unreachable for more than 24 hours, the
// data is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation PutRecord for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * InvalidArgumentException
//   The specified input parameter has an value that is not valid.
//
//   * ServiceUnavailableException
//   The service is unavailable, back off and retry the operation. If you continue
//   to see the exception, throughput limits for the delivery stream may have
//   been exceeded. For more information about limits and how to request an increase,
//   see Amazon Kinesis Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
func (c *Firehose) PutRecord(input *PutRecordInput) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	err := req.Send()
	return out, err
}

const opPutRecordBatch = "PutRecordBatch"

// PutRecordBatchRequest generates a "aws/request.Request" representing the
// client's request for the PutRecordBatch operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRecordBatch for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRecordBatch method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRecordBatchRequest method.
//    req, resp := client.PutRecordBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Firehose) PutRecordBatchRequest(input *PutRecordBatchInput) (req *request.Request, output *PutRecordBatchOutput) {
	op := &request.Operation{
		Name:       opPutRecordBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordBatchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutRecordBatchOutput{}
	req.Data = output
	return
}

// PutRecordBatch API operation for Amazon Kinesis Firehose.
//
// Writes multiple data records into a delivery stream in a single call, which
// can achieve higher throughput per producer than when writing single records.
// To write single data records into a delivery stream, use PutRecord. Applications
// using these operations are referred to as producers.
//
// Each PutRecordBatch request supports up to 500 records. Each record in the
// request can be as large as 1,000 KB (before 64-bit encoding), up to a limit
// of 4 MB for the entire request. By default, each delivery stream can take
// in up to 2,000 transactions per second, 5,000 records per second, or 5 MB
// per second. Note that if you use PutRecord and PutRecordBatch, the limits
// are an aggregate across these two operations for each delivery stream. For
// more information about limits and how to request an increase, see Amazon
// Kinesis Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// You must specify the name of the delivery stream and the data record when
// using PutRecord. The data record consists of a data blob that can be up to
// 1,000 KB in size, and any kind of data, for example, a segment from a log
// file, geographic location data, web site clickstream data, and so on.
//
// Firehose buffers records before delivering them to the destination. To disambiguate
// the data blobs at the destination, a common solution is to use delimiters
// in the data, such as a newline (\n) or some other character unique within
// the data. This allows the consumer application(s) to parse individual data
// items when reading the data from the destination.
//
// The PutRecordBatch response includes a count of any failed records, FailedPutCount,
// and an array of responses, RequestResponses. The FailedPutCount value is
// a count of records that failed. Each entry in the RequestResponses array
// gives additional information of the processed record. Each entry in RequestResponses
// directly correlates with a record in the request array using the same ordering,
// from the top to the bottom of the request and response. RequestResponses
// always includes the same number of records as the request array. RequestResponses
// both successfully and unsuccessfully processed records. Firehose attempts
// to process all records in each PutRecordBatch request. A single record failure
// does not stop the processing of subsequent records.
//
// A successfully processed record includes a RecordId value, which is a unique
// value identified for the record. An unsuccessfully processed record includes
// ErrorCode and ErrorMessage values. ErrorCode reflects the type of error and
// is one of the following values: ServiceUnavailable or InternalFailure. ErrorMessage
// provides more detailed information about the error.
//
// If FailedPutCount is greater than 0 (zero), retry the request. A retry of
// the entire batch of records is possible; however, we strongly recommend that
// you inspect the entire response and resend only those records that failed
// processing. This minimizes duplicate records and also reduces the total bytes
// sent (and corresponding charges).
//
// If the PutRecordBatch operation throws a ServiceUnavailableException, back
// off and retry. If the exception persists, it is possible that the throughput
// limits have been exceeded for the delivery stream.
//
// Data records sent to Firehose are stored for 24 hours from the time they
// are added to a delivery stream as it attempts to send the records to the
// destination. If the destination is unreachable for more than 24 hours, the
// data is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation PutRecordBatch for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * InvalidArgumentException
//   The specified input parameter has an value that is not valid.
//
//   * ServiceUnavailableException
//   The service is unavailable, back off and retry the operation. If you continue
//   to see the exception, throughput limits for the delivery stream may have
//   been exceeded. For more information about limits and how to request an increase,
//   see Amazon Kinesis Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
func (c *Firehose) PutRecordBatch(input *PutRecordBatchInput) (*PutRecordBatchOutput, error) {
	req, out := c.PutRecordBatchRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDestination = "UpdateDestination"

// UpdateDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDestination operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDestination for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDestination method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDestinationRequest method.
//    req, resp := client.UpdateDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Firehose) UpdateDestinationRequest(input *UpdateDestinationInput) (req *request.Request, output *UpdateDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDestinationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDestinationOutput{}
	req.Data = output
	return
}

// UpdateDestination API operation for Amazon Kinesis Firehose.
//
// Updates the specified destination of the specified delivery stream. Note:
// Switching between Elasticsearch and other services is not supported. For
// Elasticsearch destination, you can only update an existing Elasticsearch
// destination with this operation.
//
// This operation can be used to change the destination type (for example, to
// replace the Amazon S3 destination with Amazon Redshift) or change the parameters
// associated with a given destination (for example, to change the bucket name
// of the Amazon S3 destination). The update may not occur immediately. The
// target delivery stream remains active while the configurations are updated,
// so data writes to the delivery stream can continue during this process. The
// updated configurations are normally effective within a few minutes.
//
// If the destination type is the same, Firehose merges the configuration parameters
// specified in the UpdateDestination request with the destination configuration
// that already exists on the delivery stream. If any of the parameters are
// not specified in the update request, then the existing configuration parameters
// are retained. For example, in the Amazon S3 destination, if EncryptionConfiguration
// is not specified then the existing EncryptionConfiguration is maintained
// on the destination.
//
// If the destination type is not the same, for example, changing the destination
// from Amazon S3 to Amazon Redshift, Firehose does not merge any parameters.
// In this case, all parameters must be specified.
//
// Firehose uses the CurrentDeliveryStreamVersionId to avoid race conditions
// and conflicting merges. This is a required field in every request and the
// service only updates the configuration if the existing configuration matches
// the VersionId. After the update is applied successfully, the VersionId is
// updated, which can be retrieved with the DescribeDeliveryStream operation.
// The new VersionId should be uses to set CurrentDeliveryStreamVersionId in
// the next UpdateDestination operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation UpdateDestination for usage and error information.
//
// Returned Error Codes:
//   * InvalidArgumentException
//   The specified input parameter has an value that is not valid.
//
//   * ResourceInUseException
//   The resource is already in use and not available for this operation.
//
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ConcurrentModificationException
//   Another modification has already happened. Fetch VersionId again and use
//   it to update the destination.
//
func (c *Firehose) UpdateDestination(input *UpdateDestinationInput) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	err := req.Send()
	return out, err
}

// Describes hints for the buffering to perform before delivering data to the
// destination. Please note that these options are treated as hints, and therefore
// Firehose may choose to use different values when it is optimal.
type BufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300.
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting SizeInMBs to a value greater than the amount of data
	// you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec set SizeInMBs to be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s BufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes CloudWatch logging options for your delivery stream.
type CloudWatchLoggingOptions struct {
	_ struct{} `type:"structure"`

	// Enables or disables CloudWatch logging.
	Enabled *bool `type:"boolean"`

	// The CloudWatch group name for logging. This value is required if Enabled
	// is true.
	LogGroupName *string `type:"string"`

	// The CloudWatch log stream name for logging. This value is required if Enabled
	// is true.
	LogStreamName *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchLoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLoggingOptions) GoString() string {
	return s.String()
}

// Describes a COPY command for Amazon Redshift.
type CopyCommand struct {
	_ struct{} `type:"structure"`

	// Optional parameters to use with the Amazon Redshift COPY command. For more
	// information, see the "Optional Parameters" section of Amazon Redshift COPY
	// command (http://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html). Some
	// possible examples that would apply to Firehose are as follows.
	//
	// delimiter '\t' lzop; - fields are delimited with "\t" (TAB character) and
	// compressed using lzop.
	//
	// delimiter '| - fields are delimited with "|" (this is the default delimiter).
	//
	// delimiter '|' escape - the delimiter should be escaped.
	//
	// fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'
	// - fields are fixed width in the source, with each width specified after every
	// column in the table.
	//
	// JSON 's3://mybucket/jsonpaths.txt' - data is in JSON format, and the path
	// specified is the format of the data.
	//
	// For more examples, see Amazon Redshift COPY command examples (http://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html).
	CopyOptions *string `type:"string"`

	// A comma-separated list of column names.
	DataTableColumns *string `type:"string"`

	// The name of the target table. The table must already exist in the database.
	//
	// DataTableName is a required field
	DataTableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CopyCommand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyCommand) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyCommand) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyCommand"}
	if s.DataTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataTableName"))
	}
	if s.DataTableName != nil && len(*s.DataTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataTableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for CreateDeliveryStream.
type CreateDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The destination in Amazon ES. This value cannot be specified if Amazon S3
	// or Amazon Redshift is the desired destination (see restrictions listed above).
	ElasticsearchDestinationConfiguration *ElasticsearchDestinationConfiguration `type:"structure"`

	// The destination in Amazon Redshift. This value cannot be specified if Amazon
	// S3 or Amazon Elasticsearch is the desired destination (see restrictions listed
	// above).
	RedshiftDestinationConfiguration *RedshiftDestinationConfiguration `type:"structure"`

	// The destination in Amazon S3. This value must be specified if ElasticsearchDestinationConfiguration
	// or RedshiftDestinationConfiguration is specified (see restrictions listed
	// above).
	S3DestinationConfiguration *S3DestinationConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.ElasticsearchDestinationConfiguration != nil {
		if err := s.ElasticsearchDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDestinationConfiguration != nil {
		if err := s.RedshiftDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3DestinationConfiguration != nil {
		if err := s.S3DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CreateDeliveryStream.
type CreateDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the delivery stream.
	DeliveryStreamARN *string `type:"string"`
}

// String returns the string representation
func (s CreateDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliveryStreamOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteDeliveryStream.
type DeleteDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeleteDeliveryStream.
type DeleteDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryStreamOutput) GoString() string {
	return s.String()
}

// Contains information about a delivery stream.
type DeliveryStreamDescription struct {
	_ struct{} `type:"structure"`

	// The date and time that the delivery stream was created.
	CreateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// DeliveryStreamARN is a required field
	DeliveryStreamARN *string `type:"string" required:"true"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The status of the delivery stream.
	//
	// DeliveryStreamStatus is a required field
	DeliveryStreamStatus *string `type:"string" required:"true" enum:"DeliveryStreamStatus"`

	// The destinations.
	//
	// Destinations is a required field
	Destinations []*DestinationDescription `type:"list" required:"true"`

	// Indicates whether there are more destinations available to list.
	//
	// HasMoreDestinations is a required field
	HasMoreDestinations *bool `type:"boolean" required:"true"`

	// The date and time that the delivery stream was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Used when calling the UpdateDestination operation. Each time the destination
	// is updated for the delivery stream, the VersionId is changed, and the current
	// VersionId is required when updating the destination. This is so that the
	// service knows it is applying the changes to the correct version of the delivery
	// stream.
	//
	// VersionId is a required field
	VersionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeliveryStreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryStreamDescription) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeDeliveryStream.
type DescribeDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// Specifies the destination ID to start returning the destination information.
	// Currently Firehose supports one destination per delivery stream.
	ExclusiveStartDestinationId *string `min:"1" type:"string"`

	// The limit on the number of destinations to return. Currently, you can have
	// one destination per delivery stream.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DescribeDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.ExclusiveStartDestinationId != nil && len(*s.ExclusiveStartDestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartDestinationId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeDeliveryStream.
type DescribeDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`

	// Information about the delivery stream.
	//
	// DeliveryStreamDescription is a required field
	DeliveryStreamDescription *DeliveryStreamDescription `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryStreamOutput) GoString() string {
	return s.String()
}

// Describes the destination for a delivery stream.
type DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the destination.
	//
	// DestinationId is a required field
	DestinationId *string `min:"1" type:"string" required:"true"`

	// The destination in Amazon ES.
	ElasticsearchDestinationDescription *ElasticsearchDestinationDescription `type:"structure"`

	// The destination in Amazon Redshift.
	RedshiftDestinationDescription *RedshiftDestinationDescription `type:"structure"`

	// The Amazon S3 destination.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`
}

// String returns the string representation
func (s DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationDescription) GoString() string {
	return s.String()
}

// Describes the buffering to perform before delivering data to the Amazon ES
// destination.
type ElasticsearchBufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300 (5 minutes).
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting SizeInMBs to a value greater than the amount of data
	// you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec, set SizeInMBs to be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ElasticsearchBufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchBufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchBufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchBufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the configuration of a destination in Amazon ES.
type ElasticsearchDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Buffering options. If no value is specified, ElasticsearchBufferingHints
	// object default values are used.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The ARN of the Amazon ES domain. The IAM role must have permission for DescribeElasticsearchDomain,
	// DescribeElasticsearchDomains , and DescribeElasticsearchDomainConfig after
	// assuming RoleARN.
	//
	// DomainARN is a required field
	DomainARN *string `min:"1" type:"string" required:"true"`

	// The Elasticsearch index name.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// The Elasticsearch index rotation period. Index rotation appends a timestamp
	// to the IndexName to facilitate expiration of old data. For more information,
	// see Index Rotation for Amazon Elasticsearch Service Destination (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation).
	// Default value is OneDay.
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// Configures retry behavior in the event that Firehose is unable to deliver
	// documents to Amazon ES. Default value is 300 (5 minutes).
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The ARN of the IAM role to be assumed by Firehose for calling the Amazon
	// ES Configuration API and for indexing documents. For more information, see
	// Amazon S3 Bucket Access (http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly,
	// Firehose writes any documents that could not be indexed to the configured
	// Amazon S3 destination, with elasticsearch-failed/ appended to the key prefix.
	// When set to AllDocuments, Firehose delivers all incoming records to Amazon
	// S3, and also writes failed documents with elasticsearch-failed/ appended
	// to the prefix. For more information, see Amazon S3 Backup for Amazon Elasticsearch
	// Service Destination (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup).
	// Default value is FailedDocumentsOnly.
	S3BackupMode *string `type:"string" enum:"ElasticsearchS3BackupMode"`

	// Describes the configuration of a destination in Amazon S3.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The Elasticsearch type name.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchDestinationConfiguration"}
	if s.DomainARN == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainARN"))
	}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The destination description in Amazon ES.
type ElasticsearchDestinationDescription struct {
	_ struct{} `type:"structure"`

	// Buffering options.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// CloudWatch logging options.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The ARN of the Amazon ES domain.
	DomainARN *string `min:"1" type:"string"`

	// The Elasticsearch index name.
	IndexName *string `min:"1" type:"string"`

	// The Elasticsearch index rotation period
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// Elasticsearch retry options.
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	RoleARN *string `min:"1" type:"string"`

	// Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"ElasticsearchS3BackupMode"`

	// Describes a destination in Amazon S3.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`

	// The Elasticsearch type name.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ElasticsearchDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDestinationDescription) GoString() string {
	return s.String()
}

// Describes an update for a destination in Amazon ES.
type ElasticsearchDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// Buffering options. If no value is specified, ElasticsearchBufferingHints
	// object default values are used.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The ARN of the Amazon ES domain. The IAM role must have permission for DescribeElasticsearchDomain,
	// DescribeElasticsearchDomains , and DescribeElasticsearchDomainConfig after
	// assuming RoleARN.
	DomainARN *string `min:"1" type:"string"`

	// The Elasticsearch index name.
	IndexName *string `min:"1" type:"string"`

	// The Elasticsearch index rotation period. Index rotation appends a timestamp
	// to the IndexName to facilitate the expiration of old data. For more information,
	// see Index Rotation for Amazon Elasticsearch Service Destination (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation).
	// Default value is OneDay.
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// Configures retry behavior in the event that Firehose is unable to deliver
	// documents to Amazon ES. Default value is 300 (5 minutes).
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The ARN of the IAM role to be assumed by Firehose for calling the Amazon
	// ES Configuration API and for indexing documents. For more information, see
	// Amazon S3 Bucket Access (http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3).
	RoleARN *string `min:"1" type:"string"`

	// Describes an update for a destination in Amazon S3.
	S3Update *S3DestinationUpdate `type:"structure"`

	// The Elasticsearch type name.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ElasticsearchDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchDestinationUpdate"}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configures retry behavior in the event that Firehose is unable to deliver
// documents to Amazon ES.
type ElasticsearchRetryOptions struct {
	_ struct{} `type:"structure"`

	// After an initial failure to deliver to Amazon ES, the total amount of time
	// during which Firehose re-attempts delivery (including the first attempt).
	// After this time has elapsed, the failed documents are written to Amazon S3.
	// Default value is 300 seconds (5 minutes). A value of 0 (zero) results in
	// no retries.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s ElasticsearchRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchRetryOptions) GoString() string {
	return s.String()
}

// Describes the encryption for a destination in Amazon S3.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption key.
	KMSEncryptionConfig *KMSEncryptionConfig `type:"structure"`

	// Specifically override existing encryption information to ensure no encryption
	// is used.
	NoEncryptionConfig *string `type:"string" enum:"NoEncryptionConfig"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.KMSEncryptionConfig != nil {
		if err := s.KMSEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("KMSEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an encryption key for a destination in Amazon S3.
type KMSEncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of the encryption key. Must belong to the same region as the destination
	// Amazon S3 bucket.
	//
	// AWSKMSKeyARN is a required field
	AWSKMSKeyARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KMSEncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSEncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KMSEncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KMSEncryptionConfig"}
	if s.AWSKMSKeyARN == nil {
		invalidParams.Add(request.NewErrParamRequired("AWSKMSKeyARN"))
	}
	if s.AWSKMSKeyARN != nil && len(*s.AWSKMSKeyARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AWSKMSKeyARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for ListDeliveryStreams.
type ListDeliveryStreamsInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream to start the list with.
	ExclusiveStartDeliveryStreamName *string `min:"1" type:"string"`

	// The maximum number of delivery streams to list.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListDeliveryStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliveryStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeliveryStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeliveryStreamsInput"}
	if s.ExclusiveStartDeliveryStreamName != nil && len(*s.ExclusiveStartDeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartDeliveryStreamName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ListDeliveryStreams.
type ListDeliveryStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the delivery streams.
	//
	// DeliveryStreamNames is a required field
	DeliveryStreamNames []*string `type:"list" required:"true"`

	// Indicates whether there are more delivery streams available to list.
	//
	// HasMoreDeliveryStreams is a required field
	HasMoreDeliveryStreams *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ListDeliveryStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliveryStreamsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for PutRecordBatch.
type PutRecordBatchInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// One or more records.
	//
	// Records is a required field
	Records []*Record `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRecordBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordBatchInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Records == nil {
		invalidParams.Add(request.NewErrParamRequired("Records"))
	}
	if s.Records != nil && len(s.Records) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Records", 1))
	}
	if s.Records != nil {
		for i, v := range s.Records {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Records", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PutRecordBatch.
type PutRecordBatchOutput struct {
	_ struct{} `type:"structure"`

	// The number of unsuccessfully written records.
	//
	// FailedPutCount is a required field
	FailedPutCount *int64 `type:"integer" required:"true"`

	// The results for the individual records. The index of each element matches
	// the same index in which records were sent.
	//
	// RequestResponses is a required field
	RequestResponses []*PutRecordBatchResponseEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRecordBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordBatchOutput) GoString() string {
	return s.String()
}

// Contains the result for an individual record from a PutRecordBatch request.
// If the record is successfully added to your delivery stream, it receives
// a record ID. If the record fails to be added to your delivery stream, the
// result includes an error code and an error message.
type PutRecordBatchResponseEntry struct {
	_ struct{} `type:"structure"`

	// The error code for an individual record result.
	ErrorCode *string `type:"string"`

	// The error message for an individual record result.
	ErrorMessage *string `type:"string"`

	// The ID of the record.
	RecordId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutRecordBatchResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordBatchResponseEntry) GoString() string {
	return s.String()
}

// Contains the parameters for PutRecord.
type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The record.
	//
	// Record is a required field
	Record *Record `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}
	if s.Record != nil {
		if err := s.Record.Validate(); err != nil {
			invalidParams.AddNested("Record", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PutRecord.
type PutRecordOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the record.
	//
	// RecordId is a required field
	RecordId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordOutput) GoString() string {
	return s.String()
}

// The unit of data in a delivery stream.
type Record struct {
	_ struct{} `type:"structure"`

	// The data blob, which is base64-encoded when the blob is serialized. The maximum
	// size of the data blob, before base64-encoding, is 1,000 KB.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Record) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Record) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Record"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the configuration of a destination in Amazon Redshift.
type RedshiftDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	//
	// ClusterJDBCURL is a required field
	ClusterJDBCURL *string `min:"1" type:"string" required:"true"`

	// The COPY command.
	//
	// CopyCommand is a required field
	CopyCommand *CopyCommand `type:"structure" required:"true"`

	// The user password.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true"`

	// Configures retry behavior in the event that Firehose is unable to deliver
	// documents to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The S3 configuration for the intermediate location from which Amazon Redshift
	// obtains data. Restrictions are described in the topic for CreateDeliveryStream.
	//
	// The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration
	// because the Amazon Redshift COPY operation that reads from the S3 bucket
	// doesn't support these compression formats.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDestinationConfiguration"}
	if s.ClusterJDBCURL == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterJDBCURL"))
	}
	if s.ClusterJDBCURL != nil && len(*s.ClusterJDBCURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterJDBCURL", 1))
	}
	if s.CopyCommand == nil {
		invalidParams.Add(request.NewErrParamRequired("CopyCommand"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.CopyCommand != nil {
		if err := s.CopyCommand.Validate(); err != nil {
			invalidParams.AddNested("CopyCommand", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a destination in Amazon Redshift.
type RedshiftDestinationDescription struct {
	_ struct{} `type:"structure"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	//
	// ClusterJDBCURL is a required field
	ClusterJDBCURL *string `min:"1" type:"string" required:"true"`

	// The COPY command.
	//
	// CopyCommand is a required field
	CopyCommand *CopyCommand `type:"structure" required:"true"`

	// Configures retry behavior in the event that Firehose is unable to deliver
	// documents to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 destination.
	//
	// S3DestinationDescription is a required field
	S3DestinationDescription *S3DestinationDescription `type:"structure" required:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDestinationDescription) GoString() string {
	return s.String()
}

// Describes an update for a destination in Amazon Redshift.
type RedshiftDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	ClusterJDBCURL *string `min:"1" type:"string"`

	// The COPY command.
	CopyCommand *CopyCommand `type:"structure"`

	// The user password.
	Password *string `min:"6" type:"string"`

	// Configures retry behavior in the event that Firehose is unable to deliver
	// documents to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 destination.
	//
	// The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationUpdate.S3Update
	// because the Amazon Redshift COPY operation that reads from the S3 bucket
	// doesn't support these compression formats.
	S3Update *S3DestinationUpdate `type:"structure"`

	// The name of the user.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RedshiftDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDestinationUpdate"}
	if s.ClusterJDBCURL != nil && len(*s.ClusterJDBCURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterJDBCURL", 1))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.CopyCommand != nil {
		if err := s.CopyCommand.Validate(); err != nil {
			invalidParams.AddNested("CopyCommand", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configures retry behavior in the event that Firehose is unable to deliver
// documents to Amazon Redshift.
type RedshiftRetryOptions struct {
	_ struct{} `type:"structure"`

	// The length of time during which Firehose retries delivery after a failure,
	// starting from the initial request and including the first attempt. The default
	// value is 3600 seconds (60 minutes). Firehose does not retry if the value
	// of DurationInSeconds is 0 (zero) or if the first delivery attempt takes longer
	// than the current value.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s RedshiftRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftRetryOptions) GoString() string {
	return s.String()
}

// Describes the configuration of a destination in Amazon S3.
type S3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	BufferingHints *BufferingHints `type:"structure"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
	// destinations because they are not supported by the Amazon Redshift COPY operation
	// that reads from the S3 bucket.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. Note that if the prefix ends with a slash, it appears as a
	// folder in the S3 bucket. For more information, see Amazon S3 Object Name
	// Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide (http://docs.aws.amazon.com/firehose/latest/dev/).
	Prefix *string `type:"string"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationConfiguration"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a destination in Amazon S3.
type S3DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	//
	// BufferingHints is a required field
	BufferingHints *BufferingHints `type:"structure" required:"true"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is NOCOMPRESSION.
	//
	// CompressionFormat is a required field
	CompressionFormat *string `type:"string" required:"true" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *EncryptionConfiguration `type:"structure" required:"true"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. Note that if the prefix ends with a slash, it appears as a
	// folder in the S3 bucket. For more information, see Amazon S3 Object Name
	// Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide (http://docs.aws.amazon.com/firehose/latest/dev/).
	Prefix *string `type:"string"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationDescription) GoString() string {
	return s.String()
}

// Describes an update for a destination in Amazon S3.
type S3DestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	BucketARN *string `min:"1" type:"string"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	BufferingHints *BufferingHints `type:"structure"`

	// Describes CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is NOCOMPRESSION.
	//
	// The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
	// destinations because they are not supported by the Amazon Redshift COPY operation
	// that reads from the S3 bucket.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. Note that if the prefix ends with a slash, it appears as a
	// folder in the S3 bucket. For more information, see Amazon S3 Object Name
	// Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide (http://docs.aws.amazon.com/firehose/latest/dev/).
	Prefix *string `type:"string"`

	// The ARN of the AWS credentials.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3DestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationUpdate"}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for UpdateDestination.
type UpdateDestinationInput struct {
	_ struct{} `type:"structure"`

	// Obtain this value from the VersionId result of the DeliveryStreamDescription
	// operation. This value is required, and helps the service to perform conditional
	// operations. For example, if there is a interleaving update and this value
	// is null, then the update destination fails. After the update is successful,
	// the VersionId value is updated. The service then performs a merge of the
	// old configuration with the new configuration.
	//
	// CurrentDeliveryStreamVersionId is a required field
	CurrentDeliveryStreamVersionId *string `min:"1" type:"string" required:"true"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The ID of the destination.
	//
	// DestinationId is a required field
	DestinationId *string `min:"1" type:"string" required:"true"`

	// Describes an update for a destination in Amazon ES.
	ElasticsearchDestinationUpdate *ElasticsearchDestinationUpdate `type:"structure"`

	// Describes an update for a destination in Amazon Redshift.
	RedshiftDestinationUpdate *RedshiftDestinationUpdate `type:"structure"`

	// Describes an update for a destination in Amazon S3.
	S3DestinationUpdate *S3DestinationUpdate `type:"structure"`
}

// String returns the string representation
func (s UpdateDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDestinationInput"}
	if s.CurrentDeliveryStreamVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentDeliveryStreamVersionId"))
	}
	if s.CurrentDeliveryStreamVersionId != nil && len(*s.CurrentDeliveryStreamVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentDeliveryStreamVersionId", 1))
	}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.DestinationId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationId"))
	}
	if s.DestinationId != nil && len(*s.DestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationId", 1))
	}
	if s.ElasticsearchDestinationUpdate != nil {
		if err := s.ElasticsearchDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDestinationUpdate != nil {
		if err := s.RedshiftDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.S3DestinationUpdate != nil {
		if err := s.S3DestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3DestinationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of UpdateDestination.
type UpdateDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDestinationOutput) GoString() string {
	return s.String()
}

const (
	// CompressionFormatUncompressed is a CompressionFormat enum value
	CompressionFormatUncompressed = "UNCOMPRESSED"

	// CompressionFormatGzip is a CompressionFormat enum value
	CompressionFormatGzip = "GZIP"

	// CompressionFormatZip is a CompressionFormat enum value
	CompressionFormatZip = "ZIP"

	// CompressionFormatSnappy is a CompressionFormat enum value
	CompressionFormatSnappy = "Snappy"
)

const (
	// DeliveryStreamStatusCreating is a DeliveryStreamStatus enum value
	DeliveryStreamStatusCreating = "CREATING"

	// DeliveryStreamStatusDeleting is a DeliveryStreamStatus enum value
	DeliveryStreamStatusDeleting = "DELETING"

	// DeliveryStreamStatusActive is a DeliveryStreamStatus enum value
	DeliveryStreamStatusActive = "ACTIVE"
)

const (
	// ElasticsearchIndexRotationPeriodNoRotation is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodNoRotation = "NoRotation"

	// ElasticsearchIndexRotationPeriodOneHour is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneHour = "OneHour"

	// ElasticsearchIndexRotationPeriodOneDay is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneDay = "OneDay"

	// ElasticsearchIndexRotationPeriodOneWeek is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneWeek = "OneWeek"

	// ElasticsearchIndexRotationPeriodOneMonth is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneMonth = "OneMonth"
)

const (
	// ElasticsearchS3BackupModeFailedDocumentsOnly is a ElasticsearchS3BackupMode enum value
	ElasticsearchS3BackupModeFailedDocumentsOnly = "FailedDocumentsOnly"

	// ElasticsearchS3BackupModeAllDocuments is a ElasticsearchS3BackupMode enum value
	ElasticsearchS3BackupModeAllDocuments = "AllDocuments"
)

const (
	// NoEncryptionConfigNoEncryption is a NoEncryptionConfig enum value
	NoEncryptionConfigNoEncryption = "NoEncryption"
)
