//*****************************************************************************
//                                Version.hpp                                 *
//                               -------------                                *
// Description : Version specifier for the GNU Spice GUI application.         *
// Started     : 15/08/2003                                                   *
// Last Update : Refer below                                                  *
// Copyright   : (C) 2003 by MSWaters                                         *
// Email       : m.waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef VERSION_HPP
#define VERSION_HPP

#define  APP_NAME       wxT("gSpiceUI")
#define  APP_VERSION    wxT("1.0.00")
#define  APP_DATE       wxT("23/09/2011")
#define  APP_COPYRIGHT  wxT("Copyright (c) MSWaters 2003")

#endif // VERSION_HPP

//*****************************************************************************
// THINGS TO DO before v1.0.00 :
//
// (02/09/2011) Look for ???'s in the ChangeLog and resolve them.
//*****************************************************************************
// THINGS TO TEST before v1.0.00 :
//
// (12/04/2011) Test GNU-Cap OP analysis.
// (12/04/2011) Test GNU-Cap DC analysis.
// (12/04/2011) Test GNU-Cap AC analysis.
// (12/04/2011) Test GNU-Cap TR analysis.
// (12/04/2011) Test GNU-Cap FO analysis.
//*****************************************************************************
// THINGS TO DO in the "fullness of time" :
//
// (07/09/2011) Source synchronization isn't quite working in both the NG-Spice
//              and the GNU-Cap DC analyses. Source synchronization begins with
//              a page changed event which is first intercepted by
//              Nbk<SimEng>::OnPageChangd( ) which then allows
//              NbkSimrBase::OnPageChangd( ) to actually handle the event.
//              NbkSimrBase::OnPageChangd( ) gets a pointer to a PnlAnaBase
//              object and changes the source name, however events can only
//              propagate down from Pnl<SimEng>DC to PnlAnaBase but not back
//              the other way so Pnl<SimEng>DC never knows about the event.
//              Pnl<SimEng>DC::OnSrcName( ) is where the sweep units type is
//              ste so this doesn't happen.
// (15/04/2010) Locale stuff still appears to be broken.
//              (Maybe fixed in v0.9.99; check. Change my locale.)
// (05/09/2011) wxWidgets v2.9.2 breaks when changing simulation engines.
// (26/08/2011) Still producing "prcbase.log".
// (29/06/2011) Do include directives need to be expanded by gnetlist?
//              Simulation engine could be left to do this.
// (26/05/2011) Implement the bSaveSimCmds( ) method in the classes SimnGnuCap
//              and SimnNgSpice.
// (24/05/2011) In the simulation file place simulation commands ahead of
//              models and sub-circuits.
// (11/05/2011) Investigate replacing parts of SpinCtrl with wxSpinCtrl.
// (11/05/2011) Change class names containing "Simr" to "SimEng" and "Simn" to
//              "Sim" eg. NbkSimrBase to NbkSimEngBase and SimnBase to SimBase.
// (05/05/2011) Allow the user to set the spin control repeat rate.
// (28/04/2011) When a netlist created by gSpiceUI is loaded into the NetList
//              text control load it into the Simulation text control as well.
//              If gSpiceUI created the netlist it can be simulated.
// (28/04/2011) Now and then a spin control decrements from 1.00 to 0.00, this
//              should never happen.
// (27/04/2011) NG-Spice doesn't like probes where one of two nodes is ground,
//              eg. ".PRINT TRAN V(Trigger,0)". It complains with the message :
//                "Warning: can't parse '0': ignored"
// (19/04/2011) The way the wxProcess class is used is fault prone. wxProcess
//              objects should be created dynamically when a process is to run
//              and deleted soon after the process terminates. PrcBase inherits
//              from wxProcess, it should contain a pointer to wxProcess object
//              as an attribute.
// (23/03/2011) In the class PrcSimrBase the console spew logging mechanism is
//              clumsy; PrcSimrBase::bSaveOutput( ) does almost the same thing
//              as PrcBase::bLogOutput( ). Shouldn't have a results file should
//              just use the PrcBase log file system.
// (02/03/2011) The GNU-Cap OP analysis the "Temp" column header is missing in
//              the formatted results. Talk to GNU-Cap developer.
// (02/03/2011) When a gschem process is exited and the schematic file has
//              changed automatically do a reload and maybe re-create the
//              simulation file.
// (30/06/2010) Abbreviate most names containing NgSpice and GnuCap to Ngs and
//              Gcp respectively.
// (29/04/2010) Resolve issues compiling the code under OSX. How?
// (19/04/2010) In FrmMain::Initialize( ) if the call to m_oFileTsks.Initialize()
//              causes an error message to be displayed FrmMain is only
//              partially initialized and it looks broken.
//              Test Method :
//                1. delete the netlist file named in the config. file under
//                   "Files/NetList",
//                2. arrange it so that gnetlist can't be found by gspiceui.
// (19/04/2010) Create a Web page on sourceforge!
// (31/03/2010) At startup the simulation engine specified in a netlist file
//              should over-rule that stored in the configuration file.
// (31/03/2010) If gschem is open and the user presses the Schematic button an
//              error message is displayed, bring gschem to the foreground
//              instead. Same probably applies for gwave and Gaw.
// (30/03/2010) For all structure objects use the prefix 't' instead of 'o'.
// (01/03/2010) Implement Fourier analysis for NG-Spice.
// (11/06/2009) The NG-Spice Transient analysis cold initial conditions doesn't
//              work. Will need to implement the IC command to zero all nodes
//              voltages.
// (11/02/2009) There are 2 types of source which may be used : a sweep source
//              and a signal source. Ensure that this distinction is clearly
//              made in the code and the GUI.
// (12/12/2008) The function PrcBase::bLogOutput( ) ends early before all
//              console output is collected.
// (24/11/2008) In PnlValue class shouldn't be allowed to change value or units
//              if a component name hasn't been chosen.
// (14/05/2008) PnlValue class can be set to eg. 0.10 psec by the user but not
//              programmatically, ie. using bSetValue( ).
// (19/02/2008) If gspiceui is exited with gschem open, any unsaved changes in
//              the schematic file are lost.
// (25/10/2007) For NG-Spice simulations if R1 and C1 are connected in parallel
//              and R1 is selected as a test component after a reload operation
//              both R1 and C1 will be highlighted as test components.
// (10/10/2007) Convert NG-Spice phase results from radians to degrees. Refer
//              to section 10.5 Variables -> "units". The SET command doesn't
//              seem to work in batch mode.
// (10/10/2007) In NG-Spice the variable "numdgt" could be useful for setting
//              displayed precision. Refer to section 10.5 Variables.
// (24/08/2007) If the simulation engine is changed a few times the layout of
//              the main frame can get corrupted. Maximize then window gspiceui
//              and things are almost back to normal. Alot less corruption
//              occurs with wxWidgets v2.8.4. Using wxWidgets v2.8.5 changed
//              the simulation engine 4 times and got a segmentation fault.
//              Seems to behave better with wxWidgets v2.8.7, v2.8.9 & v2.8.10
//              but still not perfect.
// (17/07/2007) The transient analysis IC option isn't loaded correctly from
//              the simulation file for NG-Spice.
// (19/06/2007) In FrmMain the run simulation mechanism is evil. It needs a
//              major overhaul. The Stop button doesn't work because the app.
//              stays in the OnSimRun( ) event handler while the simulation
//              runs so no other events are handled until this is exited.
// (07/06/2007) If a current source (as in amperes) is chosen the source setup
//              dialogs displays units of Volts.
// (31/01/2006) While performing a simulation if the gSpiceUI GUI is corrupted
//              it isn't re-drawn until after the simulation is complete. Need
//              wxYield( ) statements in appropriate places to allow the GUI to
//              be updated.
//*****************************************************************************
// GNU-Cap :
//
// (22/03/2010) GNU-Cap seems to be broken for JFETs.
// (21/08/2009) For GNU-Cap AC analysis where a NPN BJT is used, get an error
//              message (eg. "open circuit: internal node 2") before each line
//              of the results.
// (21/04/2005) At times the first result line from a DC analysis is clearly
//              incorrect.
// (20/04/2005) In the AC analysis the following source line is not interpreted
//              correctly: "Vin 2 3 GENERATOR(1) AC 100.00m". The AC magnitude
//              "100.00m" is not interpreted as "0.1"; replace it with "0.1"
//              and everything works OK.
// (29/03/2004) The PRINT command doesn't produce a label for the independent
//              parameter ie. temperature or OP, voltage for DC.
//*****************************************************************************
// NG-Spice :
//
// (31/03/2010) NG-Spice seems to be broken for JFETs.
// (06/10/2009) NUMDGT should set the number digits to print when printing
//              tables of data. Doesn't work in batch mode.
// (11/05/2007) PRINT statement parser is broken. Eg. PRINT TRAN V(0,1) V(0,2)
//              is interpreted as one parameter -V(1)-V(2) instead of two; in
//              contrast PRINT TRAN V(1,0) V(2,0) is interpreted correctly. In
//              addition eg. PRINT AC VDB(0,1) wont run at all.
//              Notes : The .PRINT statement parsing starts in fixem( char * )
//                      (src/frontend/dotcards.c) which calls gettoks( char * )
//                      which calls gettok( char ** ) (../src/misc/string.c).
//                      I think the bug is in gettok( char ** ) or how it is
//                      used by gettoks( char * ).
//*****************************************************************************
// gNetList :
//
// (19/07/2005) If a relative model file path specified in schematic file the
//              path is regarded as relative to the CWD not the schematic file
//              path which would be more logical.
// (12/04/2005) When schem. file imported via command line "gnetlist.log" left
//              in gspiceui bin directory. When schem. file imported via GUI
//              "gnetlist.log" left in schematic directory.
//*****************************************************************************
// gWave :
//
// (29/03/2004) GWave can't handle the banner that GNU-Cap includes in it's
//              output.
//*****************************************************************************
// Gaw :
//
//*****************************************************************************
// wxWidgets Library Bugs :
//
// (03/09/2009) v2.8.10 : Class wxToolTip seems to be broken ie. can't globally
//                        enable/disable tooltips or set the tooltip delay.
// (07/09/2007) v2.8.5  : Cannot set the font in the choice control in the
//                        PnlValue class when no file loaded at startup. It
//                        should inherit the font from it's parent; every other
//                        control does. This seems to be bug in wxWidgets
//                        v2.8.5 and v2.6.3.
// (28/05/2007) v2.8.3  : In the class PnlValue class and function DoLayout( )
//                        wxWidgets ignores the request to vertically align the
//                        StaticText object.
// (04/02/2007) v2.8.3  : The class wxFileName has an undocumented function
//                        SetPath( ).
// (12/04/2005) v2.5.4  : "make uninstall" does nothing.
// (06/04/2005) v2.5.2  : When the wxFrame is resized wxStatusBar isn't.
// (01/10/2004) v2.5.2  : No mention of wxControl constructor in documentation.
// (18/09/2004) v2.5.2  : In the class wxTextCtrl style setting wxTE_RIGHT is
//                        ignored in Create( ) function.
// (13/08/2004) v2.4.2  : In class wxFileDialog styles can only be set in the
//                        constructor. The method SetStyle( ) does nothing.
// (21/02/2004) v2.4.2  : In the class wxTextFile function IsOpened( ) returns
//                        TRUE after Open( ) but FALSE after Create( ).
// (19/02/2004) v2.4.2  : In the class wxSpinCtrl when using SetValue( (int) 0 )
//                        for initialization the spin control is left blank.
// (17/11/2003) v2.4.1  : In class wxFileDialog wildcards can only be set in
//                        the constructor. The method SetWildcard( ) is not
//                        properly implemented. See constructor in
//                        src/generic/filedlgg.cpp and set method in
//                        include/wx/generic/filedlgg.h.
//*****************************************************************************
