# GNU Typist - improved typing tutor program for UNIX systems
# Copyright (C) 1998  Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series Q
#------------------------------------------------------------------------------
G:_Q_MENU
*:_Q_NO_MENU

#------------------------------------------------------------------------------
# Lesson Q1
#------------------------------------------------------------------------------
*:Q1
*:_Q_S_Q1
B:                             Lesson Q1

*:_Q_R_L0
T:			Welcome to lesson Q1.
 :
 :In the Q series of lessons, we will be learning to touch-type on the standard
 :keyboard.  I will introduce you to each letter on the keyboard, one at a time.
 :By the time you have completed this series, you will be able to type the entire
 :alphabet, the numbers, and most of the punctuation keys by touch.
 :
 :If you have never taken any lessons in typing before, please be patient.  Typing
 :is not difficult but it does take a lot of practice.  Avoid the tendency to
 :look down at your fingers while typing.  This is a very bad habit and is hard
 :to break later.  If you hit the wrong key, I will let you know.  (But, I won't
 :tell anyone else, so don't worry about it.)
 :
 :If you have always used the hunt-and-peck method, you will have an even harder
 :time keeping yourself from looking.  Don't be surprised if you find touch
 :typing slower than your old ways.  It may be slower when you first start.
 :But, touch typing is far faster once you get the hang of it.
 :
 :If you can already touch type, you should be able to go through these lessons
 :fairly quickly.  Or, you may want to go directly to the S series.

*:_Q_R_L1
T:
 :			The HOME Keys.
 :
 :In order to hit the correct keys by touch alone, you must always know where your
 :fingers are.  The way to do this is to have a special place for each finger.
 :This key is called the HOME position.
 :
 :Place the first finger of your right hand on the J-key.  Now, place your second
 :finger on the K-key, your third finger on the L-key, and your fourth-finger on
 :the ;-key (the one with the : and ; on it).
 :
 :Similarly place the four fingers of your left hand on the F, D, S, and A-keys.
 :Place your right thumb over the SPACE bar.  (Henceforth, always hit the SPACE
 :bar with this thumb.)  Now, lift all your fingers slightly so that they are
 :poised just over the keys.  Each finger should be just barely touching its home
 :key.  This is an electronic keyboard and does not take much pressure to ac-
 :cidentally press the key down.
 :
 :Above the D-key is the E-key.  Above the K-key is the I-key.  Learn these
 :positions well.  Whenever you are about to type a line, look at your fingers and
 :make sure they are in the HOME position.  Then don't look at them again.

*:_Q_R_L2
T:
 :			DRILL PATTERNS
 :
 :For the rest of this lesson, I will display a line of text in the middle of the
 :screen and instructions at the top of the screen.
 :
 :All you have to do is type in the characters that you see in the middle of
 :the screen.  If you hit the correct key, I will not do anything.  If you make
 :a mistake, I will display a large X under the letter that you got wrong and
 :beep the terminal. In either event, just keep going by typing the next letter.
 :
 :When you have finished typing the line, hit the RETURN key.  To do this, extend
 :the little finger of your right hand over to the RETURN key.  Hit the key and
 :zip the finger back to its home position.  Be careful not to let your other
 :fingers move far from their home positions in the process.  Also, be careful
 :not to type an extra space at the end of the line.
 :
 :If you made no mistakes on the line, I will display the next drill pattern.  If
 :you did make a mistake, I will beep at you and make you do the line again.  If
 :on the second try you made more than two mistakes, I will beep again and make
 :you try again, etc.  Don't forget to use your right thumb for the SPACE bar.

I:(1) Try this:
*:_Q_R_L3
D:asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj

I:Now this (use 'k' finger for 'i' and 'd' finger for 'e'):
*:_Q_R_L4
D:asdef ;lkij asdef ;lkij asdef ;lkij asdef ;lkij asdef ;lkij

I:(2) Some more:
*:_Q_R_L5
D:as al ad ak af aj fa ka da la sa ja sl sd sk sf ls ds ks fs
 :de le ae ke se je fe ed el ea ek es ej ef ed lf dk dl fl kl
 :ki ai li si di ji fi ia il is ik id ij if dd ee ss ff ll ei

I:(3) Hang in there; let's do some sentences...
 :To get capitals use your ';' finger on [right-SHIFT]
*:_Q_R_L6
D:Dad adds a salad  A lad asks  Salad falls as a lad asks Dad

I:(4) Now try [left-SHIFT] usage (for 'L') and [right-SHIFT]!
*:_Q_R_L7
D:Lease a desk  Add a safe deal  Ask less fees  Add a lease
 :Lease a lake  Add lake sales  Add deeds  Flee false deals

I:(5)
*:_Q_R_L8
D:Feel a dead faded leaf  Seeds fall as a faded leaf falls
 :A lad sells seeds  Dad feels a seed  Dad adds a seed deal
 :A deaf lad sells a false jade  Dad sells a deaf lad a sled

I:(6)
*:_Q_R_L9
D:Idle Sid seeks a salad  Sis aids Sid  A salad is laid aside
 :Sid seeks a lake  Sis is all silks  Sid likes silks
 :A lad asks if Dad likes lilies  Dad is ill  Dad feels life dies as lilies fade
 :Dad slides all lilies aside  Dad is jaded

I:(7)
*:_Q_R_L10
D:Sails fill as Sis sails a safe lake  Skill aids Sis  Dad
 :likes a safe sail  Sis seeks a lee isle  All sail is
 :laid aside  Sis feels life is ideal  Idle fields lead as
 :Sis seeks lilies  Sis falls  Lilies fade as Sis falls
 :Faded sails fill  Idle isles slide aside as Sis sails

I:(8)
*:_Q_R_L11
D:Sid adds all sail as Dad sees a safe sea as idle as a lake

G:_Q_E_Q1

#------------------------------------------------------------------------------
# Lesson Q2
#------------------------------------------------------------------------------
*:Q2
*:_Q_S_Q2
B:                             Lesson Q2

*:_Q_R_L12
T:
 :			  (h g o u n . t)
 :
 :In this lesson you learn six new letters (H, G, O, U, N, T) and the period. (.).
 :Be sure that the F-finger does not linger on the G-key  or the J-finger on the
 :H-key.  Also be sure to use your fingers as follows:
 :
 : 'f' for 't' and 'g', 'j' for 'h', 'u' and 'n', finally use 'l' for 'o' and '.'
 :
 :Note that you always follow a period with two spaces.

I:(1) Rhythm Drill
*:_Q_R_L13
D:a;sldkfjgh a;sldkfjgh a;sldkfjgh a;sldkfjgh a;sldkfjgh
 :asdefghk lokijujhjn asdefghk lokijujhjn asdefghk
 :l.  a.  l.  s.  l.  d.  l.  e.  l.  n.  l.  t.  l.  o.

I:(2) Balanced Keyboard Drill
*:_Q_R_L14
D:as os es us is an on en un in at ot et ut it ad od ed ud id
 :sa so se su si na no ne nu ni ta to te tu ti ha ho he hu hi
 :da do de du di au st oi sh oi ts ht oe nk ou nd ue ns ui th

I:(3) Continuous Copy
*:_Q_R_L15
D:Ed had a shed.  His shed had dishes.  He had shade.
 :Ed had his ease.  Sis liked a safe shed.  Sis had shade.
 :His shed is ashes.  Ed hides his head.  He heeds Sis.

I:(4)
*:_Q_R_L16
D:Odd ideas are like odd seeds.  Odd seeds die as do odd deeds.
 :Dad has odd ideas.  Dad sees a soda as a sad dose.  A soda
 :aids Sis.  So I see a soda is added.  Sis does like a soda.

I:(5)
*:_Q_R_L17
D:Sid used us.  Sid sued us.  Ada used us as aid.  I did aid.
 :I added ease.  I issued added deeds.  Ada said adieu.  Ada
 :used dead deeds as issues.  Sid said I used deeds due Ada.

I:(6)
*:_Q_R_L18
D:Ed is staid.  Ed uses tested data as assets.  Sis is a
 :tease.  Sis sets a tea date.  As Ed tastes tea I state tea
 :data.  Sis teases Ed at tea.  As Ed eats I state diet data.

I:(7)
*:_Q_R_L19
D:Sis said Dean is dense as sand.  Dean needs an idea and Sis
 :needs a sedan.  Dad sends a sedan.  Dean is indeed sad as
 :he sees Sis and Ed inside.  At nine he sees Sis and Ed dine.

I:(8) Rhythmic Review
*:_Q_R_L20
D:He sees that in a test he has to state and use a sane idea.

G:_Q_E_Q2

#------------------------------------------------------------------------------
# Lesson Q3
#------------------------------------------------------------------------------
*:Q3
*:_Q_S_Q3
B:                             Lesson Q3

*:_Q_R_L21
T:
 :			  (y r c , ? : p)
 :
 :You learned first the letters that are most frequently used in the English
 :language.  They are repeated over and over again.
 :
 :One space always follows a comma.  Don't forget there are two spaces between
 :sentences, no matter what punctuation mark closes the sentence.
 :
 :The colon (:) introduces a list and is followed by two spaces.  Finger usage:
 :
 : 'j' for 'y', 'f' for 'r', 'k' for ',', 'd' for 'c', ';' for '?', 'p' and ':'

I:(1) Rhythm Drill
*:_Q_R_L22
D:deki frju dck, dcl. frju ftjy deki frju dck, dcl. frju ftjy
 :fgjh ;p;? jujy dedc lol. kik, fgju ;:;: frfk jujy dedc kik,

I:(2) Balanced Keyboard Drill
*:_Q_R_L23
D:ag ac ar al ap at ay af ug uc ur ul up ut eg ec er el ep et
 :ey ef og or ol op ot of ig ic ir il ip if ga ca ra la pa fa
 :gu cu ru lu pu fu ge ce re le pe ye fe go co ro lo po yo fo
 :gi ci ri li fi gn pl gh ld sy rd ty ct ft ch nc dy dr ph ng
 :s?  d?  e?  f?  r?  f?  t?  j?  n?  s:  d:  e:  r:  t:  n:
 :k, i, d, e, f, r, k, u, f, t, k, y, d, c, k, n, k, h, l, o,

I:(3) Continuous Copy
*:_Q_R_L24
D:Chance can aid a nice choice.  It can teach one to count his
 :costs too.  In each such case a chance cause can hit costs.

I:(4)
*:_Q_R_L25
D:At his age a good song is the thing as he gets his dog and
 :gun.  He is going to hunt again.  As night ends he sets out.

I:(5)
*:_Q_R_L26
D:As soon as papa is deep in a nap Pat happens to pound in his
 :shop and the phone sounds.  Pat is to paint and pass up noise.

I:(6)
*:_Q_R_L27
D:I hear there is an error in her other order.  The store sent
 :her red dress to our door.  She is sure that it is too dear.

I:(7)
*:_Q_R_L28
D:I shall hold those ideal hotel lots at least until all land
 :is sold.  Late sales still total less than the one old deal.

I:(8)
*:_Q_R_L29
D:Sunday is too soon.  It is not easy to stay and study this
 :dandy day.  I need to study.  It is not easy on the eyes.

I:(9)
*:_Q_R_L30
D:One needs to use faith if one fishes often.  It is fun to sit
 :on soft sod and fish.  It is fun to feel a fish dash out fast.

I:(9A)
*:_Q_R_L31
D:Hello, is this Dan?  Hello, Dan, this is Ann.  No, Ann.  Did
 :you see Ted?  Is Nan at the house?  Then dash to the house.
 :Is he at the house?  Has he his auto?  Did he tie on those
 :odds and ends:  used suits, sun hats, shoes, and side tent?

I:(10) Rhythmic Review
*:_Q_R_L32
D:Papa can not plan to get us all there in such a car as this.

G:_Q_E_Q3

#------------------------------------------------------------------------------
# Lesson Q4
#------------------------------------------------------------------------------
*:Q4
*:_Q_S_Q4
B:                             Lesson Q4

*:_Q_R_L33
T:
 :			(m w v z x b q ' -)
 :
 :Self control is important in learning to type.  Concentrate on using the
 :correct finger for each key.  In this lesson you learn the seven remaining
 :letters of the alphabet.
 :
 :The semicolon (;), like the comma, is followed by one space in a sentence.
 :
 :Fingers:  'j' for 'm', 's' for 'w' and 'x', 'f' for 'v' and 'b',
 :';' for ' and '-', 'a' for 'z' and 'q'

I:(1) Rhythm Drill
*:_Q_R_L34
D:dedc kik, frfv jujm swsx lol. aqaz ;p;p frfv jujm ftfb jyjn
 :aqsw az;p sxl. fvjm fvjn fbjn aqsw az;p sxl. fvjm fvjn fbjn

I:(2) Balanced Keyboard Drill
*:_Q_R_L35
D:am aw av az ak ax ab um ub em ew ev ez ek eq ex om ow ov oz
 :ok ob im iv iz ix ib ma wa va za ka ja xa ba mu ju qu bu me
 :we ve ze ke je xe be mo wo vo zo ko jo bo mi wi vi zi ki xi
 :bi xt sm sk sw kn ms nk wh tw ks wn dv s; o; n; d; l; e; t;

I:(3) Continuous Copy
*:_Q_R_L36
D:Iowa was white with snow when we two went down town and saw
 :a show.  We wanted to see news and not the widow who was wed.

I:(4)
*:_Q_R_L37
D:John has to use a tan and jet auto.  He joined Jane in its
 :joint use.  Jane just intends to use it in June on a jaunt.

I:(5)
*:_Q_R_L38
D:Smith is his name.  He is on some Maine team.  I am to meet
 :him and Miss Smith.  I must see them some time this month.

I:(6)
*:_Q_R_L39
D:Kate uses ink to send a note south to Kansas kin.  She asks
 :to use a kodak to take along on these keen skates and skis.

I:(7)
*:_Q_R_L40
D:I advise Eva in vain to avoid an auto visit in seven states.
 :Nevada is so vivid that Eva votes to have this visit saved.

I:(8)
*:_Q_R_L41
D:She has questions and unique ideas to quote us.  So she is
 :quite the queen in this quiet set and sets us quaint quotas.

I:(9)
*:_Q_R_L42
D:The zoo is shut.  His zest is dashed.  Dan dozes.  One sneeze
 :and then a dozen seize Dan.  In a daze he sees the zoo seized.

I:(9A)
*:_Q_R_L43
D:The boat has been best to Boston.  On this basis no doubt one
 :is bound to be a bit behind but boats beat both dust and heat.

I:(9B)
*:_Q_R_L44
D:Nan is in Texas.  She is anxious to dine at six.  She sees a
 :taxi stand next to the sixth exit.  Taxis exist to aid one.

I:(10) Rhythmic Review
*:_Q_R_L45
D:Ask them to let us have the car if they both go to the show.

G:_Q_E_Q4

#------------------------------------------------------------------------------
# Lesson Q5
#------------------------------------------------------------------------------
*:Q5
*:_Q_S_Q5
B:                             Lesson Q5

*:_Q_R_L46
T:
 :Now you know all of the alphabet.  In this lesson we add the hyphen (-) and
 :the apostrophe (').

I:(1) Rhythm Drill
*:_Q_R_L47
D:dedc kik, frfv jujm swsx lol. aqaz ;p;p frfv jujm ftfb jyjn
 :frfk fvfb jujy jmjn aqsw azsw azsx ;plo ;p;- kik, ;p;-

I:(2) Balanced Keyboard Drill
*:_Q_R_L48
D:ad ar an al am ab ee st ed er en el es em ex om on or un up
 :id ic ir in im se sy le ly re ry ec fy ty de be my by bi di
 :l-t o-d s-c p-t o-d n-y r-o g-d r-h d-g n't t's l's y's I'l

I:(3) Continuous Copy -- Review
*:_Q_R_L49
D:It is a good thing papa has gone.  Pat gets up a deep song.
 :Yet Ann says an easy song any day is a sign to guess again.

I:(4)
*:_Q_R_L50
D:They often need funds but don't think it is any fun to study.
 :Ann is keen to ask him to use his kodak at the same time.

I:(5)
*:_Q_R_L51
D:Ted notes an odd noise.  Dan is in the seas and needs aid.
 :He sheds his suit and shoes on the sand and is out in haste.

I:(6)
*:_Q_R_L52
D:A good visit East is Ann's next quest.  Ann seems to seize
 :on this idea with zest.  She has set seven visits as a quota.

I:(7)
*:_Q_R_L53
D:She is to adjust her six visits to have a snow-white Maine
 :Christmas.  An Iowa aunt asks Ann to take in that state, too.

I:(8)
*:_Q_R_L54
D:It's a tax on time, but it's quite a new zone to Ann who is
 :in just the mood to end her quota of visits in sixteen weeks.

I:(9) Rhythmic Review
*:_Q_R_L55
D:Two of the boys are to do it today and two of them next week.

G:_Q_E_Q5

#------------------------------------------------------------------------------
# Lesson series Q jump tables
#------------------------------------------------------------------------------
*:_Q_E_Q1
Q: Do you want to continue to lesson Q2 [Y/N] ? 
N:_Q_MENU
G:_Q_S_Q2
*:_Q_E_Q2
Q: Do you want to continue to lesson Q3 [Y/N] ? 
N:_Q_MENU
G:_Q_S_Q3
*:_Q_E_Q3
Q: Do you want to continue to lesson Q4 [Y/N] ? 
N:_Q_MENU
G:_Q_S_Q4
*:_Q_E_Q4
Q: Do you want to continue to lesson Q5 [Y/N] ? 
N:_Q_MENU
G:_Q_S_Q5
*:_Q_E_Q5
G:_Q_MENU

#------------------------------------------------------------------------------
# Lesson series Q menu
#------------------------------------------------------------------------------
*:_Q_MENU
B:                      Quick QWERTY course
M: UP=_EXIT "The Q series contains the following 5 lessons"
 :_Q_S_Q1 "Lesson Q1     a s d f j k l ; e i"
 :_Q_S_Q2 "Lesson Q2     h g o u n . t"
 :_Q_S_Q3 "Lesson Q3     y r c , ? : p"
 :_Q_S_Q4 "Lesson Q4     m w v z x b q"
 :_Q_S_Q5 "Lesson Q5     ' -"
*:_Q_EXIT
#------------------------------------------------------------------------------
