/*
 * File    : NewLibraryDlg.java
 * Created : 06-sep-2004 17:09
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.project;

import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.io.File;

/**
 *
 * @author  Francesc
 */
public class NewLibraryDlg extends javax.swing.JPanel {
    
    PlayerSettings settings;
    Options options;
    
    /** Creates new form NewLibraryDlg */
    public NewLibraryDlg(PlayerSettings settings) {
        this.settings=settings;        
        this.options=settings.rb.getOptions();
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        javax.swing.ButtonGroup bg;
        javax.swing.JLabel fileLabel;
        java.awt.GridBagConstraints gridBagConstraints;

        bg = new javax.swing.ButtonGroup();
        btOptionNew = new javax.swing.JRadioButton();
        btOptionLink = new javax.swing.JRadioButton();
        fileLabel = new javax.swing.JLabel();
        fileText = new javax.swing.JTextField();
        fileBrowseBtn = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        btOptionNew.setSelected(true);
        btOptionNew.setText(options.getMsg("libraryManager_newLibaryOption"));
        bg.add(btOptionNew);
        btOptionNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btOptionNewActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 6, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(btOptionNew, gridBagConstraints);

        btOptionLink.setText(options.getMsg("libraryManager_connectToExistingOption"));
        bg.add(btOptionLink);
        btOptionLink.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btOptionLinkActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(6, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(btOptionLink, gridBagConstraints);

        fileLabel.setText(options.getMsg("libraryManager_fileOrUrlCaption"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 20, 2, 2);
        add(fileLabel, gridBagConstraints);

        fileText.setPreferredSize(new java.awt.Dimension(200, 20));
        fileText.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        add(fileText, gridBagConstraints);

        fileBrowseBtn.setText("...");
        fileBrowseBtn.setToolTipText(options.getMsg("BROWSE_FILES"));
        fileBrowseBtn.setEnabled(false);
        fileBrowseBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileBrowseBtnActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(fileBrowseBtn, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void fileBrowseBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileBrowseBtnActionPerformed

        int[] filters={Utils.JCLIC_FF};
        String result=settings.fileSystem.chooseFile(settings.rootPath+File.separator+".", false, filters, settings.rb.getOptions(), null, this, false);
            if(result!=null)
                fileText.setText(settings.fileSystem.getFullFileNamePath(result));
        
    }//GEN-LAST:event_fileBrowseBtnActionPerformed

    private void btOptionLinkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btOptionLinkActionPerformed

        checkEnabled();
        
    }//GEN-LAST:event_btOptionLinkActionPerformed

    private void btOptionNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btOptionNewActionPerformed

        checkEnabled();        
        
    }//GEN-LAST:event_btOptionNewActionPerformed
    
    public void checkEnabled(){
        fileText.setEnabled(btOptionLink.isSelected());
        fileBrowseBtn.setEnabled(btOptionLink.isSelected());
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton btOptionLink;
    private javax.swing.JRadioButton btOptionNew;
    private javax.swing.JButton fileBrowseBtn;
    private javax.swing.JTextField fileText;
    // End of variables declaration//GEN-END:variables
    
    public static LibraryManagerElement getLibraryManagerElement(LibraryManager lm, Component parent){
        NewLibraryDlg dlg=new NewLibraryDlg(lm.settings);
        Messages msg=lm.settings.rb.getOptions().getMessages();
        LibraryManagerElement result=null;
        while(result==null && msg.showInputDlg(parent, dlg, "libraryManager_newLibraryTitle")){
            if(dlg.btOptionNew.isSelected()){
                result=lm.createNewProjectLibrary(null, null);
                break;
            }
            else{
                String path=StrUtils.nullableString(dlg.fileText.getText());
                if(path==null)
                    msg.showAlert(parent, "libraryManager_warnNoFileSelected");
                else
                    result=lm.locateNewProjectLibrary(path);
            }
        }
        return result;
    }
    
}
