/*******************************************************************************/
/* Permission is hereby granted, free of charge, to any person or organization */
/* obtaining a copy of the software and accompanying documentation covered by  */
/* this license (the "Software") to use, reproduce, display, distribute,       */
/* execute, and transmit the Software, and to prepare derivative works of the  */
/* Software, and to permit third-parties to whom the Software is furnished to  */
/* do so, all subject to the following:                                        */
/*                                                                             */
/* The copyright notices in the Software and this entire statement, including  */
/* the above license grant, this restriction and the following disclaimer,     */
/* must be included in all copies of the Software, in whole or in part, and    */
/* all derivative works of the Software, unless such copies or derivative      */
/* works are solely in the form of machine-executable object code generated by */
/* a source language processor.                                                */
/*                                                                             */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  */
/* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    */
/* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT   */
/* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE   */
/* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, */
/* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER */
/* DEALINGS IN THE SOFTWARE.                                                   */
/*******************************************************************************/

#if !defined(_LFP_INTERNAL_UTILS_H_)
# define _LFP_INTERNAL_UTILS_H_

#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#if defined(__APPLE__)
# include <mach/mach.h>
#endif

static inline void
_lfp_timespec_to_timeval(struct timespec *ts, struct timeval *tv)
{
    tv->tv_sec = ts->tv_sec;
    tv->tv_usec = ts->tv_nsec / 1000;
}

static inline void
_lfp_timeval_to_timespec(struct timeval *tv, struct timespec *ts)
{
    ts->tv_sec = tv->tv_sec;
    ts->tv_nsec = tv->tv_usec * 1000;
}

#if defined(__APPLE__)
static inline void
_lfp_timespec_to_mach_timespec_t(struct timespec *ts, mach_timespec_t *mts)
{
    mts->tv_sec = ts->tv_sec;
    mts->tv_nsec = ts->tv_nsec;
}
#endif

#define SYSERR(errcode) do { errno = errcode; return -1; } while(0)

#define SYSCHECK(errcode,expr) do { if(expr) SYSERR(errcode); } while(0)

#define SYSGUARD(expr) do { if((expr) < 0) return(-1); } while(0)

/* not checking for OPEN_MAX, which might not be valid, on Linux */
#define INVALID_FD(fd) ( fd < 0 )

#endif /* _LFP_INTERNAL_UTILS_H_ */
