package Locales::DB::Language::ha;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::ha::VERSION = '0.09';

$Locales::DB::Language::ha::cldr_version = '2.0';

%Locales::DB::Language::ha::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '“',
        'alternate_quotation_start' => '“',
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "a\'a\:a",
        'yesstr' => 'i'
    },
);

%Locales::DB::Language::ha::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'Abkhazian',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'Afirkanci',
    'afa'    => "Afro\-Asiatic\ Language",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Akan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Algonquian\ Language",
    'alt'    => "Southern\ Altai",
    'am'     => 'Amharik',
    'an'     => 'Aragonese',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Apache\ Language",
    'ar'     => 'Larabci',
    'arc'    => 'Aramaic',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Artificial\ Language",
    'arw'    => 'Arawak',
    'as'     => 'Asamisanci',
    'asa'    => 'Asu',
    'ast'    => 'Asturian',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Australian\ Language",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'Aymara',
    'az'     => 'Azerbaijanci',
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Baltic\ Language",
    'be'     => 'Belarusanci',
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Bena',
    'bg'     => 'Bulgaranci',
    'bh'     => 'Bihari',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'Bengali',
    'bnt'    => 'Bantu',
    'bo'     => 'Tibetan',
    'br'     => 'Buretananci',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'Bosniyanci',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'Kataloniyanci',
    'cad'    => 'Caddo',
    'cai'    => "Central\ American\ Indian\ Language",
    'car'    => 'Carib',
    'cau'    => "Caucasian\ Language",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Celtic\ Language",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => "Harshen\ Cak",
    'csb'    => 'Kashubian',
    'cu'     => "Church\ Slavic",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => "Kabilar\ Welsh",
    'da'     => 'Danish',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'Jamusanci',
    'de_at'  => "Austrian\ German",
    'de_ch'  => "Swiss\ High\ German",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'Divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'Dzongkha',
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'Efik',
    'egy'    => "Ancient\ Egyptian",
    'eka'    => 'Ekajuk',
    'el'     => 'Girkanci',
    'elx'    => 'Elamite',
    'en'     => 'Turanci',
    'en_au'  => "Australian\ English",
    'en_ca'  => "Canadian\ English",
    'en_gb'  => "British\ English",
    'en_us'  => "U\.S\.\ English",
    'enm'    => "Middle\ English",
    'eo'     => "D\'an\/\'Yar\ Kabilar\ Andalus",
    'es'     => 'Ispaniyanci',
    'es_419' => "Latin\ American\ Spanish",
    'es_es'  => "Iberian\ Spanish",
    'et'     => 'Istoniyanci',
    'eu'     => "Dan\/\'Yar\ Kabilar\ Bas",
    'ewo'    => 'Ewondo',
    'fa'     => 'Parisanci',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => "Yaren\ mutanen\ Finland",
    'fil'    => "Dan\ Filifin",
    'fiu'    => "Finno\-Ugrian\ Language",
    'fj'     => 'Fijian',
    'fo'     => 'Faroese',
    'fon'    => 'Fon',
    'fr'     => 'Faransanci',
    'fr_ca'  => "Canadian\ French",
    'fr_ch'  => "Swiss\ French",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => "K\'abilan\ Firsi",
    'ga'     => "Dan\ Ailan",
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "K\'abilan\ Scots\ Gaelic",
    'gem'    => "Germanic\ Language",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'Bagalike',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'Guwaraniyanci',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Ancient\ Greek",
    'gsw'    => "Swiss\ German",
    'gu'     => 'Gujarati',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'Hausa',
    'hai'    => 'Haida',
    'haw'    => 'Hawaiian',
    'he'     => 'Yahudanci',
    'hi'     => "Harshen\ Hindi",
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'Kuroshiyan',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'Haitian',
    'hu'     => "Harshen\ Hungari",
    'hup'    => 'Hupa',
    'hy'     => 'Armeniyanci',
    'hz'     => 'Herero',
    'ia'     => "Yare\ Tsakanin\ Kasashe",
    'iba'    => 'Iban',
    'id'     => "Harshen\ Indunusiya",
    'ie'     => 'Intagulanci',
    'ig'     => 'Inyamuranci',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indic\ Language",
    'ine'    => "Indo\-European\ Language",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => "Yaren\ mutanen\ Iceland",
    'it'     => 'Italiyanci',
    'iu'     => 'Inuktitut',
    'ja'     => 'Japananci',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => 'Jabananci',
    'ka'     => 'Jojiyanci',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'Kazakh',
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => "Harshen\ Kimar",
    'kmb'    => 'Kimbundu',
    'kn'     => "Dan\/\'Yar\ Kabilar\ Kannada",
    'ko'     => "Harshen\ Koreya",
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'Kashmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'Kurdanci',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'Kirgizanci',
    'la'     => "Dan\ Kabilar\ Latin",
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'Luxembourgish',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'Lingala',
    'lo'     => 'Laothian',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'Lituweniyanci',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => 'Latbiyanci',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'Malagasy',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'Maori',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => "Dan\ Masedoniya",
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => "Kabilar\ Maleyalam",
    'mn'     => 'Mongolian',
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => "K\'abilan\ Marathi",
    'ms'     => "Harshen\ Malai",
    'mt'     => "Harshen\ Maltis",
    'mua'    => 'Mundang',
    'mul'    => "Multiple\ Languages",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => 'Burmanci',
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "North\ American\ Indian\ Language",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "Norwegian\ Bokm\Ã\¥l",
    'nd'     => "North\ Ndebele",
    'nds'    => "Low\ German",
    'ne'     => 'Nepali',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'Holanci',
    'nl_be'  => 'Flemish',
    'nmg'    => 'Kwasio',
    'nn'     => "Yaren\ Kasar\ Norway",
    'no'     => "Yaren\ mutanen\ Norway",
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "Northern\ Sotho",
    'nub'    => "Nubian\ Language",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'Nyanja',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'Ositanci',
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'Oriyanci',
    'os'     => 'Ossetic',
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => 'Punjabi',
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Philippine\ Language",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => "Harshen\ Polan",
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => 'Pashtanci',
    'pt'     => "Harshen\ Portugal",
    'pt_br'  => "Fotigis\ \(Burazil\)",
    'pt_pt'  => "Yaren\ Kasar\ Portugal",
    'qu'     => 'Quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'Romansh',
    'rn'     => 'Rundi',
    'ro'     => 'Romaniyanci',
    'roa'    => "Romance\ Language",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => 'Rashanci',
    'rup'    => 'Aromanian',
    'rw'     => 'Kiniyaruwanda',
    'rwk'    => 'Rwa',
    'sa'     => 'sanskrit',
    'sad'    => 'Sandawe',
    'sah'    => 'Sakha',
    'sai'    => "South\ American\ Indian\ Language",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => 'Sindiyanci',
    'se'     => "Northern\ Sami",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitic\ Language",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'Sango',
    'sga'    => "Old\ Irish",
    'sgn'    => "Sign\ Language",
    'sh'     => "Kuroweshiyancin\-Sabiya",
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'Sinhalanci',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => 'Basulake',
    'sl'     => 'Basulabe',
    'sla'    => "Slavic\ Language",
    'sm'     => 'Samoan',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'Shona',
    'snk'    => 'Soninke',
    'so'     => 'Somali',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => "D\'an\/\'Yar\ Kabilar\ Albaniya",
    'sr'     => 'Sabiyan',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'Swati',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => 'Sesotanci',
    'su'     => 'Sundanese',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => "Harshen\ Suwedan",
    'sw'     => "Harshen\ Suwahili",
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => 'Tamil',
    'tai'    => "Tai\ Language",
    'te'     => "D\'an\/\'Yar\ Kabilar\ Telug",
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'Tetum',
    'tg'     => 'Tajik',
    'th'     => 'Thai',
    'ti'     => 'Tigriyanci',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'Tukmenistanci',
    'tkl'    => 'Tokelau',
    'tl'     => 'Tagalog',
    'tlh'    => 'Klingon',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'Tswana',
    'to'     => 'Tonga',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "Tok\ Pisin",
    'tr'     => "Harshen\ Turkiyya",
    'trv'    => 'Taroko',
    'ts'     => 'Tsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Tatar',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Altaic\ Language",
    'tvl'    => 'Tuvalu',
    'tw'     => 'Tiwiniyanci',
    'twq'    => 'Tasawaq',
    'ty'     => 'Tahitian',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'Ugiranci',
    'uga'    => 'Ugaritic',
    'uk'     => "Harshen\ Yukuren",
    'umb'    => 'Umbundu',
    'und'    => "Unknown\ Language",
    'ur'     => "Harshen\ Urdu",
    'uz'     => 'Uzbek',
    'vai'    => 'Vai',
    've'     => 'Venda',
    'vi'     => "Harshen\ Biyetinam",
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'Wolof',
    'xal'    => 'Kalmyk',
    'xh'     => 'Bazosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'Yiddish',
    'yo'     => 'Yarbanci',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'Cantonese',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => "Harshen\ Sin",
    'znd'    => 'Zande',
    'zu'     => "Harshen\ Zulu",
    'zun'    => 'Zuni',
    'zxx'    => "No\ linguistic\ content",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::ha::name_to_code = (
    'abkhazian'                     => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afirkanci'                     => 'af',
    'afrihili'                      => 'afh',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amharik'                       => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armeniyanci'                   => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asamisanci'                    => 'as',
    'asturian'                      => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'azerbaijanci'                  => 'az',
    'bafia'                         => 'ksf',
    'bagalike'                      => 'gl',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'basulabe'                      => 'sl',
    'basulake'                      => 'sk',
    'batak'                         => 'btk',
    'bazosa'                        => 'xh',
    'beja'                          => 'bej',
    'belarusanci'                   => 'be',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'bengali'                       => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bihari'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'bosniyanci'                    => 'bs',
    'braj'                          => 'bra',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'bulgaranci'                    => 'bg',
    'buretananci'                   => 'br',
    'buriat'                        => 'bua',
    'burmanci'                      => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'cantonese'                     => 'yue',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'comorian'                      => 'swb',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    "dan\/yarkabilaralbaniya"       => 'sq',
    "dan\/yarkabilarandalus"        => 'eo',
    "dan\/yarkabilarbas"            => 'eu',
    "dan\/yarkabilarkannada"        => 'kn',
    "dan\/yarkabilartelug"          => 'te',
    'danailan'                      => 'ga',
    'danfilifin'                    => 'fil',
    'danish'                        => 'da',
    'dankabilarlatin'               => 'la',
    'danmasedoniya'                 => 'mk',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'faransanci'                    => 'fr',
    'faroese'                       => 'fo',
    'fijian'                        => 'fj',
    'finnougrianlanguage'           => 'fiu',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'fotigisburazil'                => 'pt_br',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'girkanci'                      => 'el',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'gujarati'                      => 'gu',
    'gusii'                         => 'guz',
    'guwaraniyanci'                 => 'gn',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'harshenbiyetinam'              => 'vi',
    'harshencak'                    => 'cs',
    'harshenhindi'                  => 'hi',
    'harshenhungari'                => 'hu',
    'harshenindunusiya'             => 'id',
    'harshenkimar'                  => 'km',
    'harshenkoreya'                 => 'ko',
    'harshenmalai'                  => 'ms',
    'harshenmaltis'                 => 'mt',
    'harshenpolan'                  => 'pl',
    'harshenportugal'               => 'pt',
    'harshensin'                    => 'zh',
    'harshensuwahili'               => 'sw',
    'harshensuwedan'                => 'sv',
    'harshenturkiyya'               => 'tr',
    'harshenurdu'                   => 'ur',
    'harshenyukuren'                => 'uk',
    'harshenzulu'                   => 'zu',
    'hausa'                         => 'ha',
    'hawaiian'                      => 'haw',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'holanci'                       => 'nl',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'ingush'                        => 'inh',
    'intagulanci'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'inyamuranci'                   => 'ig',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'ispaniyanci'                   => 'es',
    'istoniyanci'                   => 'et',
    'italiyanci'                    => 'it',
    'jabananci'                     => 'jv',
    'jamusanci'                     => 'de',
    'japananci'                     => 'ja',
    'jju'                           => 'kaj',
    'jojiyanci'                     => 'ka',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabilanfirsi'                  => 'fy',
    'kabilanmarathi'                => 'mr',
    'kabilanscotsgaelic'            => 'gd',
    'kabilarmaleyalam'              => 'ml',
    'kabilarwelsh'                  => 'cy',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'kataloniyanci'                 => 'ca',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kiniyaruwanda'                 => 'rw',
    'kirgizanci'                    => 'ky',
    'klingon'                       => 'tlh',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdanci'                      => 'ku',
    'kuroshiyan'                    => 'hr',
    'kuroweshiyancinsabiya'         => 'sh',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'laothian'                      => 'lo',
    'larabci'                       => 'ar',
    'latbiyanci'                    => 'lv',
    'latinamericanspanish'          => 'es_419',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lituweniyanci'                 => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'luyia'                         => 'luy',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'malagasy'                      => 'mg',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongolian'                     => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nepali'                        => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriyanci'                      => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ositanci'                      => 'oc',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'parisanci'                     => 'fa',
    'pashtanci'                     => 'ps',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'punjabi'                       => 'pa',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'rashanci'                      => 'ru',
    'romancelanguage'               => 'roa',
    'romaniyanci'                   => 'ro',
    'romansh'                       => 'rm',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'rundi'                         => 'rn',
    'rwa'                           => 'rwk',
    'sabiyan'                       => 'sr',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sangu'                         => 'sbp',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serer'                         => 'srr',
    'sesotanci'                     => 'st',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindiyanci'                    => 'sd',
    'sinhalanci'                    => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'somali'                        => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'sundanese'                     => 'su',
    'susu'                          => 'sus',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'tamil'                         => 'ta',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tatar'                         => 'tt',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'thai'                          => 'th',
    'tibetan'                       => 'bo',
    'tigre'                         => 'tig',
    'tigriyanci'                    => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tiwiniyanci'                   => 'tw',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tukmenistanci'                 => 'tk',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turanci'                       => 'en',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'ugiranci'                      => 'ug',
    'umbundu'                       => 'umb',
    'unknownlanguage'               => 'und',
    'uppersorbian'                  => 'hsb',
    'uzbek'                         => 'uz',
    'vai'                           => 'vai',
    'venda'                         => 've',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'yahudanci'                     => 'he',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yarbanci'                      => 'yo',
    'yarenkasarnorway'              => 'nn',
    'yarenkasarportugal'            => 'pt_pt',
    'yarenmutanenfinland'           => 'fi',
    'yarenmutaneniceland'           => 'is',
    'yarenmutanennorway'            => 'no',
    'yaretsakaninkasashe'           => 'ia',
    'yiddish'                       => 'yi',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
);

1;
