/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import org.netbeans.modules.profiler.api.icons.Icons;

/**
 *
 * @author Jiri Sedlacek
 */
public interface ProfilingPointsIcons extends Icons.Keys {
    
    public static final String CODE = "ProfilingPointsIcons.Code"; // NOI18N
    public static final String GLOBAL = "ProfilingPointsIcons.Global"; // NOI18N
    public static final String LOAD_GENERATOR = "ProfilingPointsIcons.LoadGenerator"; // NOI18N
    public static final String LOAD_GENERATOR_DISABLED = "ProfilingPointsIcons.LoadGeneratorDisabled"; // NOI18N
    public static final String PPOINT = "ProfilingPointsIcons.PPoint"; // NOI18N
    public static final String ADD = "ProfilingPointsIcons.Add"; // NOI18N
    public static final String EDIT = "ProfilingPointsIcons.Edit"; // NOI18N
    public static final String ENABLE_DISABLE = "ProfilingPointsIcons.EnableDisable"; // NOI18N
    public static final String REMOVE = "ProfilingPointsIcons.Remove"; // NOI18N
    public static final String RESET_RESULTS = "ProfilingPointsIcons.ResetResults"; // NOI18N
    public static final String RESET_RESULTS_DISABLED = "ProfilingPointsIcons.ResetResultsDisabled"; // NOI18N
    public static final String STOPWATCH = "ProfilingPointsIcons.Stopwatch"; // NOI18N
    public static final String STOPWATCH_DISABLED = "ProfilingPointsIcons.StopwatchDisabled"; // NOI18N
    public static final String TAKE_SNAPSHOT = "ProfilingPointsIcons.TakeSnapshot"; // NOI18N
    public static final String TAKE_SNAPSHOT_DISABLED = "ProfilingPointsIcons.TakeSnapshotDisabled"; // NOI18N
    public static final String TAKE_SNAPSHOT_TIMED = "ProfilingPointsIcons.TakeSnapshotTimed"; // NOI18N
    public static final String TAKE_SNAPSHOT_TRIGGERED = "ProfilingPointsIcons.TakeSnapshotTriggered"; // NOI18N
    
    
}
