/*
 * Generated by util/mkerr.pl DO NOT EDIT
 * Copyright 1995-2023 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the OpenSSL license (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */

#ifndef HEADER_QATERR_H
# define HEADER_QATERR_H

# include <openssl/symhacks.h>

# define QATerr(f, r) ERR_QAT_error((f), (r), OPENSSL_FILE, OPENSSL_LINE)


# ifdef  __cplusplus
extern "C" {
# endif
int ERR_load_QAT_strings(void);
void ERR_unload_QAT_strings(void);
void ERR_QAT_error(int function, int reason, char *file, int line);
# ifdef  __cplusplus
}
# endif

/*
 * QAT function codes.
 */
# define QAT_F_AES_GCM_TLS_CIPHER                         100
# define QAT_F_BUILD_DECRYPT_OP_BUF                       101
# define QAT_F_BUILD_ENCRYPT_OP_BUF                       102
# define QAT_F_CRT_COMBINE                                103
# define QAT_F_CRT_PREPARE                                104
# define QAT_F_ENGINE_FINISH_BEFORE_FORK_HANDLER          105
# define QAT_F_ENGINE_INIT_CHILD_AT_FORK_HANDLER          106
# define QAT_F_ENGINE_QAT                                 107
# define QAT_F_EVENT_POLL_FUNC                            108
# define QAT_F_MB_ECDH_COMPUTE_KEY                        109
# define QAT_F_MB_ECDH_GENERATE_KEY                       110
# define QAT_F_MB_ECDSA_DO_VERIFY                         111
# define QAT_F_MB_ECDSA_SIGN                              112
# define QAT_F_MB_ECDSA_SIGN_SETUP                        113
# define QAT_F_MB_ECDSA_SIGN_SIG                          114
# define QAT_F_MB_ECDSA_SM2_SIGN                          115
# define QAT_F_MB_ECDSA_SM2_VERIFY                        116
# define QAT_F_MB_ECDSA_VERIFY                            117
# define QAT_F_MB_SM2_CTRL                                118
# define QAT_F_MB_SM2_INIT                                119
# define QAT_F_MULTIBUFF_RSA_ADD_PADDING_PRIV_ENC         120
# define QAT_F_MULTIBUFF_RSA_ADD_PADDING_PUB_ENC          121
# define QAT_F_MULTIBUFF_RSA_PRIV_DEC                     122
# define QAT_F_MULTIBUFF_RSA_PRIV_ENC                     123
# define QAT_F_MULTIBUFF_RSA_PUB_DEC                      124
# define QAT_F_MULTIBUFF_RSA_PUB_ENC                      125
# define QAT_F_MULTIBUFF_VALIDATE_ECX_DERIVE              126
# define QAT_F_MULTIBUFF_X25519_DERIVE                    127
# define QAT_F_MULTIBUFF_X25519_KEYGEN                    128
# define QAT_F_POLL_INSTANCES                             129
# define QAT_F_QAT_ADJUST_THREAD_AFFINITY                 130
# define QAT_F_QAT_AES_CCM_CIPHER                         131
# define QAT_F_QAT_AES_CCM_CLEANUP                        132
# define QAT_F_QAT_AES_CCM_CTRL                           133
# define QAT_F_QAT_AES_CCM_INIT                           134
# define QAT_F_QAT_AES_CCM_SESSION_INIT                   135
# define QAT_F_QAT_AES_CCM_TLS_CIPHER                     136
# define QAT_F_QAT_AES_GCM_CIPHER                         137
# define QAT_F_QAT_AES_GCM_CLEANUP                        138
# define QAT_F_QAT_AES_GCM_CTRL                           139
# define QAT_F_QAT_AES_GCM_INIT                           140
# define QAT_F_QAT_AES_GCM_SESSION_INIT                   141
# define QAT_F_QAT_AES_GCM_TLS_CIPHER                     142
# define QAT_F_QAT_CHACHA20_POLY1305_CLEANUP              143
# define QAT_F_QAT_CHACHA20_POLY1305_CTRL                 144
# define QAT_F_QAT_CHACHA20_POLY1305_DO_CIPHER            145
# define QAT_F_QAT_CHACHA20_POLY1305_INIT                 146
# define QAT_F_QAT_CHACHA20_POLY1305_INIT_KEY_IV          147
# define QAT_F_QAT_CHACHA20_POLY1305_MAC_KEYGEN           148
# define QAT_F_QAT_CHACHA20_POLY1305_TLS_CIPHER           149
# define QAT_F_QAT_CHACHAPOLY_SESSION_DATA_INIT           150
# define QAT_F_QAT_CHACHAPOLY_SETUP_OP_PARAMS             151
# define QAT_F_QAT_CREATE_SM4_CBC_CIPHER_METH             152
# define QAT_F_QAT_CREATE_SM4_CCM_CIPHER_METH             153
# define QAT_F_QAT_CRYPTO_CALLBACKFN                      154
# define QAT_F_QAT_DH_COMPUTE_KEY                         155
# define QAT_F_QAT_DH_GENERATE_KEY                        156
# define QAT_F_QAT_DSA_DO_SIGN                            157
# define QAT_F_QAT_DSA_DO_VERIFY                          158
# define QAT_F_QAT_DSA_SIGN_SETUP                         159
# define QAT_F_QAT_ECDH_COMPUTE_KEY                       160
# define QAT_F_QAT_ECDH_GENERATE_KEY                      161
# define QAT_F_QAT_ECDSA_DO_SIGN                          162
# define QAT_F_QAT_ECDSA_DO_VERIFY                        163
# define QAT_F_QAT_ECDSA_SIGN                             164
# define QAT_F_QAT_ECDSA_VERIFY                           165
# define QAT_F_QAT_ENGINE_CTRL                            166
# define QAT_F_QAT_ENGINE_ECDH_COMPUTE_KEY                167
# define QAT_F_QAT_FD_CLEANUP                             168
# define QAT_F_QAT_GET_DH_METHODS                         169
# define QAT_F_QAT_GET_DSA_METHODS                        170
# define QAT_F_QAT_GET_EC_METHODS                         171
# define QAT_F_QAT_GET_RSA_METHODS                        172
# define QAT_F_QAT_HKDF_CTRL                              173
# define QAT_F_QAT_HKDF_DERIVE                            174
# define QAT_F_QAT_HKDF_INIT                              175
# define QAT_F_QAT_HKDF_PMETH                             176
# define QAT_F_QAT_HW_CREATE_SM3_METH                     177
# define QAT_F_QAT_HW_FINISH_INT                          178
# define QAT_F_QAT_HW_INIT                                179
# define QAT_F_QAT_HW_SHA3_OFFLOAD                        180
# define QAT_F_QAT_HW_SM2_COMPUTE_Z_DIGEST                181
# define QAT_F_QAT_HW_SM3_CLEANUP                         182
# define QAT_F_QAT_HW_SM3_COPY                            183
# define QAT_F_QAT_HW_SM3_DO_OFFLOAD                      184
# define QAT_F_QAT_HW_SM3_FINAL                           185
# define QAT_F_QAT_HW_SM3_SETUP_PARAM                     186
# define QAT_F_QAT_HW_SM3_UPDATE                          187
# define QAT_F_QAT_INIT_OP_DONE                           188
# define QAT_F_QAT_INIT_OP_DONE_PIPE                      189
# define QAT_F_QAT_INIT_OP_DONE_RSA_CRT                   190
# define QAT_F_QAT_MOD_EXP                                191
# define QAT_F_QAT_PKEY_ECX_DERIVE25519                   192
# define QAT_F_QAT_PKEY_ECX_DERIVE448                     193
# define QAT_F_QAT_PKEY_ECX_KEYGEN                        194
# define QAT_F_QAT_PRF_PMETH                              195
# define QAT_F_QAT_PRF_TLS_DERIVE                         196
# define QAT_F_QAT_REMAP_INSTANCES                        197
# define QAT_F_QAT_RSA_DECRYPT                            198
# define QAT_F_QAT_RSA_DECRYPT_CRT                        199
# define QAT_F_QAT_RSA_ENCRYPT                            200
# define QAT_F_QAT_RSA_PRIV_DEC                           201
# define QAT_F_QAT_RSA_PRIV_ENC                           202
# define QAT_F_QAT_RSA_PUB_DEC                            203
# define QAT_F_QAT_RSA_PUB_ENC                            204
# define QAT_F_QAT_SESSION_DATA_INIT                      205
# define QAT_F_QAT_SETUP_OP_PARAMS                        206
# define QAT_F_QAT_SET_INSTANCE_FOR_THREAD                207
# define QAT_F_QAT_SHA3_CLEANUP                           208
# define QAT_F_QAT_SHA3_CTRL                              209
# define QAT_F_QAT_SHA3_FINAL                             210
# define QAT_F_QAT_SHA3_SESSION_DATA_INIT                 211
# define QAT_F_QAT_SHA3_SETUP_PARAM                       212
# define QAT_F_QAT_SHA3_UPDATE                            213
# define QAT_F_QAT_SM2_COMPUTE_Z_DIGEST                   214
# define QAT_F_QAT_SM2_COPY                               215
# define QAT_F_QAT_SM2_CTRL                               216
# define QAT_F_QAT_SM2_DIGEST_CUSTOM                      217
# define QAT_F_QAT_SM2_INIT                               218
# define QAT_F_QAT_SM2_SIGN                               219
# define QAT_F_QAT_SM2_VERIFY                             220
# define QAT_F_QAT_SM4_CBC_CLEANUP                        221
# define QAT_F_QAT_SM4_CBC_DO_CIPHER                      222
# define QAT_F_QAT_SM4_CBC_INIT                           223
# define QAT_F_QAT_SW_INIT                                224
# define QAT_F_QAT_SW_SM3_FINAL                           225
# define QAT_F_QAT_SW_SM3_INIT                            226
# define QAT_F_QAT_SW_SM3_UPDATE                          227
# define QAT_F_QAT_SW_SM4_CBC_CIPHER                      228
# define QAT_F_QAT_SW_SM4_CBC_CLEANUP                     229
# define QAT_F_QAT_SW_SM4_CBC_KEY_INIT                    230
# define QAT_F_QAT_SW_SM4_CCM_CLEANUP                     231
# define QAT_F_QAT_SW_SM4_CCM_CTRL                        232
# define QAT_F_QAT_SW_SM4_CCM_DECRYPT                     233
# define QAT_F_QAT_SW_SM4_CCM_DO_CIPHER                   234
# define QAT_F_QAT_SW_SM4_CCM_ENCRYPT                     235
# define QAT_F_QAT_SW_SM4_CCM_INIT                        236
# define QAT_F_QAT_SW_SM4_GCM_CIPHER                      237
# define QAT_F_QAT_SW_SM4_GCM_CLEANUP                     238
# define QAT_F_QAT_SW_SM4_GCM_CTRL                        239
# define QAT_F_QAT_SW_SM4_GCM_DECRYPT                     240
# define QAT_F_QAT_SW_SM4_GCM_ENCRYPT                     241
# define QAT_F_QAT_SW_SM4_GCM_INIT                        242
# define QAT_F_QAT_SW_SM4_GCM_TLS_CIPHER                  243
# define QAT_F_QAT_SYM_PERFORM_OP                         244
# define QAT_F_QAT_VALIDATE_ECX_DERIVE                    245
# define QAT_F_QAT_X25519_PMETH                           246
# define QAT_F_QAT_X448_PMETH                             247
# define QAT_F_SM2_COMPUTE_MSG_HASH                       248
# define QAT_F_VAESGCM_CIPHERS_CTRL                       249
# define QAT_F_VAESGCM_CIPHERS_DO_CIPHER                  250
# define QAT_F_VAESGCM_CIPHERS_INIT                       251
# define QAT_F_VAESGCM_INIT_GCM                           252
# define QAT_F_VAESGCM_INIT_IPSEC_MB_MGR                  253
# define QAT_F_VAESGCM_INIT_KEY                           254

/*
 * QAT reason codes.
 */
# define QAT_R_AAD_INVALID_PTR                            100
# define QAT_R_AAD_LEN_INVALID                            101
# define QAT_R_AAD_MALLOC_FAILURE                         102
# define QAT_R_ADD_M2_FAILURE                             103
# define QAT_R_ADJUST_DELTA_M1_M2_FAILURE                 104
# define QAT_R_ALGO_TYPE_SUPPORTED                        105
# define QAT_R_ALGO_TYPE_UNSUPPORTED                      106
# define QAT_R_ALLOC_E_CHECK_FAILURE                      107
# define QAT_R_ALLOC_MULTIBUFF_RSA_METH_FAILURE           108
# define QAT_R_ALLOC_QAT_DSA_METH_FAILURE                 109
# define QAT_R_ALLOC_QAT_RSA_METH_FAILURE                 110
# define QAT_R_ALLOC_QAT_X25519_METH_FAILURE              111
# define QAT_R_ALLOC_QAT_X448_METH_FAILURE                112
# define QAT_R_ALLOC_TAG_FAILURE                          113
# define QAT_R_BAD_INPUT_PARAMS                           114
# define QAT_R_BN_LIB_FAILURE                             115
# define QAT_R_BUFFER_TOO_SMALL                           116
# define QAT_R_BUF_CONV_FAIL                              117
# define QAT_R_CAPABILITY_FAILURE                         118
# define QAT_R_CBC_OPERATION_FAILED                       119
# define QAT_R_CHACHAPOLY_CTX_NULL                        120
# define QAT_R_CIPHER_DATA_NULL                           121
# define QAT_R_CIPHER_OPERATION_FAILED                    122
# define QAT_R_CLOSE_READFD_FAILURE                       123
# define QAT_R_COMPUTE_FAILURE                            124
# define QAT_R_COMPUTE_H_MULTIPLY_Q_FAILURE               125
# define QAT_R_CP_BUF_MALLOC_FAILURE                      126
# define QAT_R_CQ_BUF_MALLOC_FAILURE                      127
# define QAT_R_CREATE_FREELIST_QUEUE_FAILURE              128
# define QAT_R_CTX_MALLOC_FAILURE                         129
# define QAT_R_CTX_NULL                                   130
# define QAT_R_CURVE_COORDINATE_PARAMS_CONVERT_TO_FB_FAILURE 131
# define QAT_R_CURVE_DOES_NOT_SUPPORT_SIGNING             132
# define QAT_R_C_MODULO_P_FAILURE                         133
# define QAT_R_C_MODULO_Q_FAILURE                         134
# define QAT_R_C_P_Q_CP_CQ_MALLOC_FAILURE                 135
# define QAT_R_DEC_OP_DATA_MALLOC_FAILURE                 136
# define QAT_R_DERIVE_FAILURE                             137
# define QAT_R_DGSTLEN_INVALID                            138
# define QAT_R_DGST_BN_CONV_FAILURE                       139
# define QAT_R_DH_NULL                                    140
# define QAT_R_DINIT_OPERATION_FAILED                     141
# define QAT_R_DLEN_INVALID                               142
# define QAT_R_DSA_DGST_NULL                              143
# define QAT_R_DSA_DGST_SIG_NULL                          144
# define QAT_R_ECDH_GET_AFFINE_COORD_FAILED               145
# define QAT_R_ECDH_GROUP_NULL                            146
# define QAT_R_ECDH_PRIVATE_KEY_NULL                      147
# define QAT_R_ECDH_PRIV_KEY_PUB_KEY_NULL                 148
# define QAT_R_ECDH_SET_AFFINE_COORD_FAILED               149
# define QAT_R_ECDH_UNKNOWN_FIELD_TYPE                    150
# define QAT_R_ECDSA_MALLOC_FAILURE                       151
# define QAT_R_ECDSA_SIGN_FAILURE                         152
# define QAT_R_ECDSA_SIGN_NULL                            153
# define QAT_R_ECDSA_SIGN_SETUP_FAILURE                   154
# define QAT_R_ECDSA_SIG_MALLOC_FAILURE                   155
# define QAT_R_ECDSA_SIG_SET_R_S_FAILURE                  156
# define QAT_R_ECDSA_VERIFY_FAILURE                       157
# define QAT_R_ECDSA_VERIFY_NULL                          158
# define QAT_R_ECKEY_GROUP_PUBKEY_SIG_NULL                159
# define QAT_R_EC_KEY_GROUP_PRIV_KEY_NULL                 160
# define QAT_R_EC_LIB                                     161
# define QAT_R_EC_POINT_RETRIEVE_FAILURE                  162
# define QAT_R_EINIT_OPERATION_FAILED                     163
# define QAT_R_ENC_OP_DATA_MALLOC_FAILURE                 164
# define QAT_R_ENGINE_CTRL_CMD_FAILURE                    165
# define QAT_R_ENGINE_INIT_FAILURE                        166
# define QAT_R_ENGINE_NULL                                167
# define QAT_R_EPOLL_CREATE_FAILURE                       168
# define QAT_R_EPOLL_CTL_FAILURE                          169
# define QAT_R_EVENTS_MALLOC_FAILURE                      170
# define QAT_R_EVP_LIB                                    171
# define QAT_R_FAILED_TO_GET_PARAMETER                    172
# define QAT_R_FAILED_TO_SET_PARAMETER                    173
# define QAT_R_FALLBACK_INIT_FAILURE                      174
# define QAT_R_FALLBACK_POINTER_NULL                      175
# define QAT_R_FIELD_SIZE_INVALID                         176
# define QAT_R_FREE_DH_METH_FAILURE                       177
# define QAT_R_FREE_MULTIBUFF_RSA_METH_FAILURE            178
# define QAT_R_FREE_QAT_DSA_METH_FAILURE                  179
# define QAT_R_FREE_QAT_RSA_METH_FAILURE                  180
# define QAT_R_GCM_TAG_VERIFY_FAILURE                     181
# define QAT_R_GET_COFACTOR_FAILURE                       182
# define QAT_R_GET_FILE_DESCRIPTOR_FAILURE                183
# define QAT_R_GET_GROUP_FAILURE                          184
# define QAT_R_GET_INSTANCE_FAILURE                       185
# define QAT_R_GET_INSTANCE_INFO_FAILURE                  186
# define QAT_R_GET_NUM_INSTANCE_FAILURE                   187
# define QAT_R_GET_ORDER_FAILURE                          188
# define QAT_R_GET_PQG_FAILURE                            189
# define QAT_R_GET_PRIV_KEY_FAILURE                       190
# define QAT_R_GROUP_NULL                                 191
# define QAT_R_GROUP_PRIV_KEY_PUB_KEY_NULL                192
# define QAT_R_GROUP_PUB_KEY_NULL                         193
# define QAT_R_H_CONVERT_TO_FB_FAILURE                    194
# define QAT_R_ICP_SAL_USERSTART_FAIL                     195
# define QAT_R_ID_TOO_LARGE                               196
# define QAT_R_INITIALIZE_CTX_FAILURE                     197
# define QAT_R_INIT_FAILURE                               198
# define QAT_R_INPUT_DATA_MALLOC_FAILURE                  199
# define QAT_R_INPUT_PARAM_INVALID                        200
# define QAT_R_INSTANCE_HANDLE_MALLOC_FAILURE             201
# define QAT_R_INSTANCE_UNAVAILABLE                       202
# define QAT_R_INTERNAL_ERROR                             203
# define QAT_R_INVALID_AAD                                204
# define QAT_R_INVALID_ATTACHED_TAG                       205
# define QAT_R_INVALID_CTRL_TYPE                          206
# define QAT_R_INVALID_CURVE                              207
# define QAT_R_INVALID_DATA                               208
# define QAT_R_INVALID_DIGEST                             209
# define QAT_R_INVALID_HASH_DATA                          210
# define QAT_R_INVALID_INPUT                              211
# define QAT_R_INVALID_INPUT_LENGTH                       212
# define QAT_R_INVALID_INPUT_PARAMETER                    213
# define QAT_R_INVALID_IVLEN                              214
# define QAT_R_INVALID_IV_LENGTH                          215
# define QAT_R_INVALID_KEY_LENGTH                         216
# define QAT_R_INVALID_L                                  217
# define QAT_R_INVALID_LEN                                218
# define QAT_R_INVALID_PEER_KEY                           219
# define QAT_R_INVALID_PRIVATE_KEY                        220
# define QAT_R_INVALID_PTR                                221
# define QAT_R_INVALID_PTR_IV                             222
# define QAT_R_INVALID_PUB_KEY                            223
# define QAT_R_INVALID_QCTX_MEMORY                        224
# define QAT_R_INVALID_TAG                                225
# define QAT_R_INVALID_TAG_LEN                            226
# define QAT_R_INVALID_TYPE                               227
# define QAT_R_IN_KINV_CONVERT_TO_FB_FAILURE              228
# define QAT_R_IN_R_CONVERT_TO_FB_FAILURE                 229
# define QAT_R_IPSEC_MGR_NULL                             230
# define QAT_R_IV_ALLOC_FAILURE                           231
# define QAT_R_IV_GEN_INVALID                             232
# define QAT_R_IV_INVALID                                 233
# define QAT_R_IV_LEN_NOT_SUPPORTED                       234
# define QAT_R_IV_MALLOC_FAILURE                          235
# define QAT_R_IV_NOTSET                                  236
# define QAT_R_IV_NULL_PTR_INVALID                        237
# define QAT_R_IV_NVALID                                  238
# define QAT_R_KEYGEN_FAILURE                             239
# define QAT_R_KEYS_NOT_SET                               240
# define QAT_R_KEY_IV_NOT_SET                             241
# define QAT_R_KEY_MALLOC_FAILURE                         242
# define QAT_R_KEY_NOTSET                                 243
# define QAT_R_KEY_NULL                                   244
# define QAT_R_K_ALLOCATE_FAILURE                         245
# define QAT_R_K_CONVERT_TO_FB_FAILURE                    246
# define QAT_R_K_E_ORDER_MALLOC_FAILURE                   247
# define QAT_R_K_ORDER_CONVERT_TO_FB_FAILURE              248
# define QAT_R_K_RAND_GENERATE_FAILURE                    249
# define QAT_R_M1_DEDUCT_M2_FAILURE                       250
# define QAT_R_M1_M2_P_Q_QINV_TMP_MALLOC_FAILURE          251
# define QAT_R_MALLOC_FAILURE                             252
# define QAT_R_MAX_RETRIES_EXCEEDED                       253
# define QAT_R_MB_FREE_EC_METHOD_FAILURE                  254
# define QAT_R_MB_GET_EC_METHOD_MALLOC_FAILURE            255
# define QAT_R_MODULO_P_FAILURE                           256
# define QAT_R_MOD_GET_NEXT_INST_FAIL                     257
# define QAT_R_MOD_LN_MOD_EXP_FAIL                        258
# define QAT_R_MOD_SETUP_ASYNC_EVENT_FAIL                 259
# define QAT_R_MSGLEN_NOTSET                              260
# define QAT_R_MULTIPLY_QINV_FAILURE                      261
# define QAT_R_NID_NOT_SUPPORTED                          262
# define QAT_R_NO_PARAMETERS_SET                          263
# define QAT_R_N_E_CONVERT_TO_FB_FAILURE                  264
# define QAT_R_N_E_NULL                                   265
# define QAT_R_OP1_BASE_PDATA_MALLOC_FAILURE              266
# define QAT_R_OP2_BASE_PDATA_MALLOC_FAILURE              267
# define QAT_R_OPDATA_A_PDATA_MALLOC_FAILURE              268
# define QAT_R_OPDATA_DATA_MALLOC_FAILURE                 269
# define QAT_R_OPDATA_D_MALLOC_FAILURE                    270
# define QAT_R_OPDATA_E_MALLOC_FAILURE                    271
# define QAT_R_OPDATA_K_MALLOC_FAILURE                    272
# define QAT_R_OPDATA_MALLOC_FAILURE                      273
# define QAT_R_OPDATA_PDATA_MALLOC_FAILURE                274
# define QAT_R_OPDATA_ZPDATA_MALLOC_FAILURE               275
# define QAT_R_OPDCRT_NULL                                276
# define QAT_R_OPDONE_NULL                                277
# define QAT_R_OPDPIPE_NULL                               278
# define QAT_R_ORDER_MALLOC_FAILURE                       279
# define QAT_R_OUT1_PDATA_MALLOC_FAILURE                  280
# define QAT_R_OUT2_PDATA_MALLOC_FAILURE                  281
# define QAT_R_OUTPUT_BUFFER_TOO_SMALL                    282
# define QAT_R_OUTPUT_BUF_MALLOC_FAILURE                  283
# define QAT_R_OUTPUT_BUF_PDATA_MALLOC_FAILURE            284
# define QAT_R_OUTX_MALLOC_FAILURE                        285
# define QAT_R_OUTX_OUTY_LEN_NULL                         286
# define QAT_R_OUTY_MALLOC_FAILURE                        287
# define QAT_R_PADDING_UNKNOWN                            288
# define QAT_R_POLLING_THREAD_CREATE_FAILURE              289
# define QAT_R_POLLING_THREAD_SEM_INIT_FAILURE            290
# define QAT_R_POLLING_THREAD_SIGMASK_FAILURE             291
# define QAT_R_POLL_INSTANCE_FAILURE                      292
# define QAT_R_POPDATA_A_PDATA_MALLOC_FAILURE             293
# define QAT_R_POPDATA_MALLOC_FAILURE                     294
# define QAT_R_POPDATA_PCURVE_MALLOC_FAILURE              295
# define QAT_R_PPV_MALLOC_FAILURE                         296
# define QAT_R_PPV_PDATA_MALLOC_FAILURE                   297
# define QAT_R_PRESULTR_MALLOC_FAILURE                    298
# define QAT_R_PRESULTR_PDATA_MALLOC_FAILURE              299
# define QAT_R_PRESULTS_MALLOC_FAILURE                    300
# define QAT_R_PRESULTS_PDATA_MALLOC_FAILURE              301
# define QAT_R_PRESULTX_MALLOC_FAILURE                    302
# define QAT_R_PRESULTX_PDATA_MALLOC_FAILURE              303
# define QAT_R_PRESULTY_LENGTH_CHECK_FAILURE              304
# define QAT_R_PRESULTY_MALLOC_FAILURE                    305
# define QAT_R_PRESULTY_PDATA_MALLOC_FAILURE              306
# define QAT_R_PRIV_KEY_DUPLICATE_FAILURE                 307
# define QAT_R_PRIV_KEY_K_E_D_CONVERT_TO_FB_FAILURE       308
# define QAT_R_PRIV_KEY_MALLOC_FAILURE                    309
# define QAT_R_PRIV_KEY_M_XG_YG_A_B_P_CONVERT_TO_FB_FAILURE 310
# define QAT_R_PRIV_KEY_NULL                              311
# define QAT_R_PRIV_KEY_RAND_GENERATE_FAILURE             312
# define QAT_R_PRIV_KEY_XG_YG_A_B_P_CONVERT_TO_FB_FAILURE 313
# define QAT_R_PRIV_KEY_XP_YP_A_B_P_CONVERT_TO_FB_FAILURE 314
# define QAT_R_PTHREAD_CREATE_FAILURE                     315
# define QAT_R_PTHREAD_GETAFFINITY_FAILURE                316
# define QAT_R_PTHREAD_JOIN_FAILURE                       317
# define QAT_R_PTHREAD_SETAFFINITY_FAILURE                318
# define QAT_R_PUB_KEY_DUPLICATE_FAILURE                  319
# define QAT_R_PUB_KEY_MALLOC_FAILURE                     320
# define QAT_R_PUB_KEY_NULL                               321
# define QAT_R_P_A_B_XG_YG_MALLOC_FAILURE                 322
# define QAT_R_P_A_B_XG_YG_M_K_R_ORDER_MALLOC_FAILURE     323
# define QAT_R_P_A_B_XG_YG_XP_YP_M_ORDER_FAILURE          324
# define QAT_R_P_A_B_XP_YP_FAILURE                        325
# define QAT_R_P_A_B_XP_YP_MALLOC_FAILURE                 326
# define QAT_R_P_G_PRIV_KEY_CONVERT_TO_FB_FAILURE         327
# define QAT_R_P_PUB_PRIV_KEY_CONVERT_TO_FB_FAILURE       328
# define QAT_R_P_Q_DMP_DMQ_CONVERT_TO_FB_FAILURE          329
# define QAT_R_P_Q_DMP_DMQ_IQMP_NULL                      330
# define QAT_R_P_Q_G_NULL                                 331
# define QAT_R_P_Q_G_X_K_CONVERT_TO_FB_FAILURE            332
# define QAT_R_P_Q_G_Y_Z_R_S_CONVERT_TO_FB_FAILURE        333
# define QAT_R_QAT_ALLOC_DH_METH_FAILURE                  334
# define QAT_R_QAT_CREATE_ENGINE_FAILURE                  335
# define QAT_R_QAT_ECDSA_DO_SIGN_FAIL                     336
# define QAT_R_QAT_FREE_EC_METHOD_FAILURE                 337
# define QAT_R_QAT_GET_EC_METHOD_MALLOC_FAILURE           338
# define QAT_R_QAT_SET_DH_METH_FAILURE                    339
# define QAT_R_QCTX_CTX_NULL                              340
# define QAT_R_QCTX_NULL                                  341
# define QAT_R_RAND_BYTES_FAILURE                         342
# define QAT_R_RAND_FAILURE                               343
# define QAT_R_RAND_GENERATE_FAILURE                      344
# define QAT_R_RESULT_PDATA_ALLOC_FAIL                    345
# define QAT_R_RETRIEVE_EC_POINT_FAILURE                  346
# define QAT_R_RETRIEVE_ORDER_FAILURE                     347
# define QAT_R_RSA_FROM_TO_NULL                           348
# define QAT_R_RSA_OUTPUT_BUF_PDATA_MALLOC_FAILURE        349
# define QAT_R_R_Q_COMPARE_FAILURE                        350
# define QAT_R_SECRET_KEY_MALLOC_FAILURE                  351
# define QAT_R_SECRET_KEY_PDATA_MALLOC_FAILURE            352
# define QAT_R_SEM_POST_FAILURE                           353
# define QAT_R_SETUP_ASYNC_EVENT_FAILURE                  354
# define QAT_R_SET_ADDRESS_TRANSLATION_FAILURE            355
# define QAT_R_SET_FILE_DESCRIPTOR_NONBLOCKING_FAILURE    356
# define QAT_R_SET_INSTANCE_FAILURE                       357
# define QAT_R_SET_MULTIBUFF_RSA_METH_FAILURE             358
# define QAT_R_SET_NOTIFICATION_CALLBACK_FAILURE          359
# define QAT_R_SET_POLLING_THREAD_AFFINITY_FAILURE        360
# define QAT_R_SET_PRIV_KEY_FAILURE                       361
# define QAT_R_SET_QAT_DSA_METH_FAILURE                   362
# define QAT_R_SET_QAT_RSA_METH_FAILURE                   363
# define QAT_R_SET_TAG_INVALID_OP                         364
# define QAT_R_SHA3_CTX_NULL                              365
# define QAT_R_SIG_GET_R_S_FAILURE                        366
# define QAT_R_SIG_MALLOC_FAILURE                         367
# define QAT_R_SM2_BAD_SIGNATURE                          368
# define QAT_R_SM2_ID_TOO_LARGE                           369
# define QAT_R_SM2_INVALID_DIGEST                         370
# define QAT_R_SM2_SIGN_NULL                              371
# define QAT_R_SM2_SIG_GEN_MALLOC_FAILURE                 372
# define QAT_R_SM2_SIG_MALLOC_FAILURE                     373
# define QAT_R_SM2_SIG_SET_R_S_FAILURE                    374
# define QAT_R_SM2_VERIFY_NULL                            375
# define QAT_R_SM3_CTX_NULL                               376
# define QAT_R_SM3_FINAL_FAILURE                          377
# define QAT_R_SM3_INIT_FAILURE                           378
# define QAT_R_SM3_UPDATE_FAILURE                         379
# define QAT_R_SM4_CCM_DECRYPT_FAILURE                    380
# define QAT_R_SM4_GCM_DECRYPT_FAILURE                    381
# define QAT_R_SM4_GCM_ENCRYPT_FAILURE                    382
# define QAT_R_SM4_GET_INSTANCE_FAILED                    383
# define QAT_R_SM4_GET_SESSIONCTX_SIZE_FAILED             384
# define QAT_R_SM4_MALLOC_FAILED                          385
# define QAT_R_SM4_NO_QAT_INSTANCE_AVAILABLE              386
# define QAT_R_SM4_NULL_CKEY                              387
# define QAT_R_SM4_NULL_CTX                               388
# define QAT_R_SM4_NULL_CTX_OR_KEY                        389
# define QAT_R_SM4_NULL_POINTER                           390
# define QAT_R_SM4_NULL_QCTX                              391
# define QAT_R_SM4_QAT_CONTEXT_NOT_INITIALISED            392
# define QAT_R_SM4_QAT_INITSESSION_FAILED                 393
# define QAT_R_SM4_QAT_SUBMIT_REQUEST_FAILED              394
# define QAT_R_SM4_REMOVE_SESSION_FAILED                  395
# define QAT_R_SM4_SETUP_META_DATA_FAILED                 396
# define QAT_R_SM4_SET_METHODS_FAILED                     397
# define QAT_R_SSD_MALLOC_FAILURE                         398
# define QAT_R_SSD_NULL                                   399
# define QAT_R_START_INSTANCE_FAILURE                     400
# define QAT_R_STOP_INSTANCE_FAILURE                      401
# define QAT_R_SW_GET_COMPUTE_KEY_PFUNC_NULL              402
# define QAT_R_SW_GET_KEYGEN_PFUNC_NULL                   403
# define QAT_R_SW_GET_SIGN_PFUNC_NULL                     404
# define QAT_R_SW_GET_SIGN_SETUP_PFUNC_NULL               405
# define QAT_R_SW_GET_SIGN_SIG_PFUNC_NULL                 406
# define QAT_R_SW_GET_VERIFY_PFUNC_NULL                   407
# define QAT_R_SW_GET_VERIFY_SIG_PFUNC_NULL               408
# define QAT_R_SW_METHOD_NULL                             409
# define QAT_R_S_NULL                                     410
# define QAT_R_S_Q_COMPARE_FAILURE                        411
# define QAT_R_TAG_NOTSET                                 412
# define QAT_R_TAG_NOT_NEEDED                             413
# define QAT_R_UNKNOWN_PADDING                            414
# define QAT_R_UNKNOWN_PADDING_TYPE                       415
# define QAT_R_WAKE_PAUSE_JOB_FAILURE                     416
# define QAT_R_X_Y_E_MALLOC_FAILURE                       417
# define QAT_R_X_Y_TX_TY_BN_MALLOC_FAILURE                418
# define QAT_R_X_Y_Z_MALLOC_FAILURE                       419
# define QAT_R_ZALLOC_FAILURE                             420
# define QAT_R_Z_ALLOCATE_FAILURE                         421

#endif
