/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EDITORSCENE_H
#define EDITORSCENE_H

#include <QGraphicsScene>
//#include "graphics.h"
#include "graphicitems.h"
class QGraphicsSceneMouseEvent;

#define CHANGECOLOR
#define CHANGE

struct sconvert
{
  QChar tag;
  QString replacement;
};



class editorScene : public QGraphicsScene
{
	Q_OBJECT

public:
	enum eImageType
		{
			NONE,				/*!< no image defined */
			FLATIMAGE, /*!< loaded image is a simple image (png,jpeg,...) */
			TEMPLATE    /*!< loaded image is a template file */
		};
	enum eMode { MOVE, INSERT,PICK};
	enum doChange {NOCHANGE = 0, FILLCOLOR = 1, LINECOLOR=2, GRADIENT=4,TEXT = 8,FONT=16,PEN=32,TRANSFORM=64};
	Q_DECLARE_FLAGS(changeFlags, doChange);
  editorScene(QGraphicsView *parent=0);
	~editorScene();
	QColor fillColor;
	QColor lineColor;
	QGradient gradient;
	QColor gradientColor;
	QFont  font;
	QString text;
	QString fl;
	double penWidth;
	void apply(changeFlags cf);
	void clearAll();
	QRectF border;
	int rotate;
	qreal hShear;
	qreal vShear;
	bool load(QFile &f);
	bool save(QFile &f,bool templ);
  void setImage(QImage *im);
	eMode mode;
	eImageType getImageType(){return imageType;}
  QImage *renderImage();
  QList<sconvert> convertList;
  void overlay(QImage *ima);
  void addBorder(int w,int h);
  QImage *getImagePtr() {return localImage;}

// bool event(QEvent *);

public slots:
	void setMode(eMode m);
	void setItemType(itemBase::egraphType tp);
//    void editorLostFocus(DiagramTextItem *item);
	void slotCopy();
	void slotPaste();
	void slotExpand();

	void slotDeleteItem();
	void slotLock();
	void slotUnlock();
	void slotBringToFront();
	void slotSendToBack();
	void slotSendBackward();
	void slotSendForward();
	void slotChangeText();

signals:
//	void itemInserted(itemBase *itm);
//	void textInserted(itemBase *itm);
	void changeSize(int,int);
	void itemSelected(itemBase *itm);
	void colorSelected( const QPointF &p);

protected:
	void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);
	void mouseMoveEvent(QGraphicsSceneMouseEvent *mouseEvent);
	void mouseReleaseEvent(QGraphicsSceneMouseEvent *mouseEvent);


private:
	itemBase *copyItem;
	itemBase::egraphType itemType;
	bool leftButtonDown;

	bool pasted;
	qreal zMax;
	QPointF startPoint;
// Context menus
	QMenu *contextMenu;
	QMenu *arrange;

	void optimizeDepth();
	void itemSetup(itemBase *item);
	void makeCopy(itemBase *it);
	eImageType imageType;
  QImage *localImage;
  void flattenImage();
  void convertText();
  QString textConversion(QString str);
  QString convertedText;
  itemBase *borderItemPtr;
  void convertReplayImage();

};
Q_DECLARE_OPERATORS_FOR_FLAGS(editorScene::changeFlags)

#endif
