/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef NOTICE_H
#define NOTICE_H

#include <QObject>
#include <QtPlugin>
#include <QPushButton>
#include <QDebug>
#include <QVector>
#include <QGSettings>
#include <QVBoxLayout>
#include <QDir>
#include <QComboBox>

#include <shell/interface.h>
#include "titlelabel.h"
#include "lightlabel.h"
#include "kswitchbutton.h"
#include "switchwidget.h"
#include "settinggroup.h"
#include "noticeui.h"
using namespace kdk;

/* qt会将glib里的signals成员识别为宏，所以取消该宏
 * 后面如果用到signals时，使用Q_SIGNALS代替即可
 **/
#ifdef signals
#undef signals
#endif

#include <glib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>

struct NoticeApp
{
    QString desktop;
    QString name;
    QString icon;
    bool status;
    bool voice;
    bool detail;
    bool show;
    int mode;
};
const QDBusArgument &operator<<(QDBusArgument &argument, const NoticeApp &app);
const QDBusArgument &operator>>(const QDBusArgument &argument, NoticeApp &app);
Q_DECLARE_METATYPE(NoticeApp)

class Notice : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:
    Notice();
    ~Notice();

    QString plugini18nName() Q_DECL_OVERRIDE;
    int pluginTypes() Q_DECL_OVERRIDE;
    QWidget * pluginUi() Q_DECL_OVERRIDE;
    const QString name() const  Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

    void setupComponent();
    void setupGSettings();
    void initItemUi(NoticeApp &app);
    void initOriNoticeStatus();
    void setAppIcon(QLabel *label, const QString &icon);


private:
    void setHiddenNoticeApp(bool status);
    void setComBoxStatus(bool status);

private:
    QString pluginName;
    int pluginType;
    NoticeUi *mNoticeWidget;

    QMap<QLabel*, QString> mIconLabelMap;
    bool mFirstLoad;
    QDBusInterface *mNoticeDBus;

public slots:
    void keyChangedSlot(const QString &key);

};
#endif // NOTICE_H
