/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QDir>
#include <QTimer>
#include <QMainWindow>
#include <QPaintEvent>
#include <QShowEvent>
#include <QMoveEvent>
#include <QHideEvent>
#include <QPainter>
#include <QPropertyAnimation>
#include <QVariantMap>
#include <QGSettings/QGSettings>
#include <QHBoxLayout>
#include <QToolButton>
#include <QScrollArea>

#include "kaboutdialog.h"
#include "interface.h"
#include "homepagewidget.h"
#include "modulepagewidget.h"
#include "searchwidget.h"
#include "knavigationbar.h"
#include "windowmanager/windowmanager.h"

class QLabel;
class QPushButton;
class QButtonGroup;

using namespace kdk;
namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public:
    void setModuleBtnHightLight(int id);
    void bootOptionsFilter(QString opt, bool firstIn = true);        // 模块跳转
    void moveEvent(QMoveEvent *event);
    void resizeEvent(QResizeEvent *event);
    QString pluginBtnHoverColor(QString styleName, bool hoverFlag);
    QVariantMap getSearchItems();
    void loadAllModules();
    void initPageWidget();

protected:
    bool eventFilter(QObject *watched, QEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void keyReleaseEvent(QKeyEvent *event) Q_DECL_OVERRIDE; //键盘松开事件

private:
    Ui::MainWindow *ui;

private:
    HomePageWidget * homepageWidget;
    ModulePageWidget * modulepageWidget = nullptr;

    QButtonGroup * leftBtnGroup;
    QButtonGroup * leftMicBtnGroup; //

    QDir pluginsDir;
    QDir updatePluginDir;

    SearchWidget      * m_searchWidget;

    QPushButton *backBtn;
    QToolButton *mOptionBtn;
    QPushButton *minBtn;
    QPushButton *maxBtn;
    QPushButton *closeBtn;
    QLabel      *titleLabel;
    QLabel      *mTitleIcon;
    QIcon       m_titleIcon;
    QLabel      *mLogoSetLabel;
    QTimer      *timer;
    QStringList       m_updatePlugins;
    QVariantMap       m_ModuleMap;
    QGSettings       *m_fontSetting;
    bool is_ExitPower = false;

    QHBoxLayout     *titleLayout;
    KNavigationBar *scrollArea = nullptr;

    QDBusInterface *m_statusSessionDbus;
    bool is_tabletmode;
    bool isTabletMode = false;

    QList<WindowId> m_listWinIds;
    QMap<QString, QGSettings *> vecGsettins;
    QList<char *> pluginPathList;
    int mFirstKey = 0;
    bool isLoad;
    bool loadWidget;

private:
    void preInit();
    void initUI();
    void initTileBar();
    void setBtnLayout(QPushButton * &pBtn);
    void loadPlugins();
    void loadUpdatePlugins();
    void determinePlugin(const QString& fileName, const QDir& dir);
    void loadSpecifiedPlugin(QString pluginFullName);
    void initLeftsideBar();
    QGSettings *setGsettingsPath(QList<char *> list , QString name);
    bool isExitsCloudAccount();
    bool isExitsPower();
    bool isExitWirelessDevice();
    bool dblOnEdge(QMouseEvent *event);
    void initStyleSheet();
    void changeSearchSlot();
    void showGuide(QString pluName);
    void hideComponent();

public slots:
    void pluginBtnClicked(QObject * plugin);
    void functionBtnClicked(QObject * plugin, QString jumpText = "");
    void sltMessageReceived(const QString &msg);
    void switchPage(QString moduleName, QString jumpMoudle, QString jumpText = "");
    void mainWindow_statusDbusSlot(bool tablet_mode);
    void initUkccAbout();
    void onF1ButtonClicked();

Q_SIGNALS:
    void posChanged();
    void specifiedPluginLoaded(CommonInterface *pluginInstance);
    void tabletModeChanged(bool isTablet);
};

#endif // MAINWINDOW_H
