/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_integrate_ip.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_integrate_ip.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_INTEGRATE_IP_H
#define XMDS_INTEGRATE_IP_H

#include <xmds_integrate.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsIntegrateIP
// *****************************************************************************
// *****************************************************************************

//! Class to integrate the equations in the interaction picture
class xmdsIntegrateIP : public virtual xmdsIntegrate {

  public :

    //! Constructor of xmdsIntegrateIP object
    xmdsIntegrateIP(
        const xmdsSimulation *const yourSimulation,
        const bool& yourVerboseMode);

  //! Destructor
  ~xmdsIntegrateIP();

  //! Processes the element
  void processElement(
                      const Element *const yourElement);

  protected :

    //! Writes the function prototypes to outfile
    void writePrototypes(
       FILE *const outfile) const;

  //! Writes the routines to outfile
  void writeRoutines(
                     FILE *const outfile) const;

  private :

    //! Write the calculate k-operator field routine to file
    void writeCalculatekOperatorFieldRoutine(
               FILE *const outfile) const;

  //! Write the constant k-operators propagate routine to file
  void writeConstkPropagateRoutine(
                                   FILE *const outfile) const;

  //! Write the time dependent k-operators propagate routine to file
  void writeTimeDepkPropagateRoutine(
                                     FILE *const outfile) const;

  //! Write the calculate k-operator field routine for the adaptive algorithm to file
  void writeARK45CalculatekOperatorFieldRoutine(
            FILE *const outfile) const;

  //! Write the calculate k-operator field routine for the adaptive algorithm to file
  void writeARK45TimeDepkCalculatekOperatorFieldRoutine(
              FILE *const outfile) const;

  //! Write the constant k-operators propagate routine for the adaptive algorithm to file
  void writeARK45kPropagateRoutine(
                                   FILE *const outfile) const;

  //! Write the calculate k-operator field routine for the adaptive algorithm to file
  void writeRK9CalculatekOperatorFieldRoutine(
                FILE *const outfile) const;

  //! Write the calculate k-operator field routine for the adaptive algorithm to file
  void writeRK9TimeDepkCalculatekOperatorFieldRoutine(
                  FILE *const outfile) const;

  //! Write the constant k-operators propagate routine for the adaptive algorithm to file
  void writeRK9kPropagateRoutine (
          FILE *const outfile) const;



};


#endif // XMDS_INTEGRATE_IP_H
