**1. Create a systemd unit for acme.sh:**

`/etc/systemd/system/acme_letsencrypt.service`
```
[Unit]
Description=Renew Let's Encrypt certificates using acme.sh
After=network-online.target nss-lookup.target

[Service]
Type=oneshot
SyslogIdentifier=acme.sh
# --home's argument should be where the acme.sh script resides.
ExecStart=/path/to/acme.sh --cron --home /path/to/acme.sh
```

**2. Disable timestamps (optional):**

`/path/to/acme.sh/account.conf`
```
NO_TIMESTAMP='1'
```

**3. Test that it works before creating the timer:**
```
sudo systemctl daemon-reload
sudo systemctl start acme_letsencrypt
journalctl -u acme_letsencrypt.service
```

**4. Create systemd timer unit for the service above:**

`/etc/systemd/system/acme_letsencrypt.timer`
```
[Unit]
Description=Daily renewal of Let's Encrypt's certificates

[Timer]
OnCalendar=daily
RandomizedDelaySec=1h
Persistent=true

[Install]
WantedBy=timers.target
```

**5. Enable timer:**
```
sudo systemctl start acme_letsencrypt.timer
sudo systemctl enable acme_letsencrypt.timer
```