(******************************************************************************)
(*     The Alt-Ergo theorem prover                                            *)
(*     Copyright (C) 2006-2013                                                *)
(*     CNRS - INRIA - Universite Paris Sud                                    *)
(*                                                                            *)
(*     Sylvain Conchon                                                        *)
(*     Evelyne Contejean                                                      *)
(*                                                                            *)
(*     Francois Bobot                                                         *)
(*     Mohamed Iguernelala                                                    *)
(*     Stephane Lescuyer                                                      *)
(*     Alain Mebsout                                                          *)
(*                                                                            *)
(*   This file is distributed under the terms of the CeCILL-C licence         *)
(******************************************************************************)

open Hashcons 

type t = string hash_consed

val make : string -> t

val view : t -> string

val equal : t -> t -> bool

val compare : t -> t -> int

val hash : t -> int

val empty : t 

val list_assoc : t -> (t * 'a) list -> 'a

val fresh_string : unit -> string

val is_fresh_string : string -> bool

