/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;

public class SetterStore {
    public static final String SETTER_STORE_FILE_EXT = "-setter_store.bin";
    private static SetterStore sStore;
    private final IntermediateV1 mStore;
    private final ModelAnalyzer mClassAnalyzer;
    private Comparator<MultiAttributeSetter> COMPARE_MULTI_ATTRIBUTE_SETTERS = new Comparator<MultiAttributeSetter>(){

        @Override
        public int compare(MultiAttributeSetter o1, MultiAttributeSetter o2) {
            ModelClass view2;
            if (o1.attributes.length != o2.attributes.length) {
                return o2.attributes.length - o1.attributes.length;
            }
            ModelClass view1 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o1).mKey.viewType, null);
            if (!view1.equals(view2 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o2).mKey.viewType, null))) {
                if (view1.isAssignableFrom(view2)) {
                    return 1;
                }
                return -1;
            }
            if (!((MultiAttributeSetter)o1).mKey.attributeIndices.keySet().equals(((MultiAttributeSetter)o2).mKey.attributeIndices.keySet())) {
                Iterator<String> o1Keys = ((MultiAttributeSetter)o1).mKey.attributeIndices.keySet().iterator();
                Iterator<String> o2Keys = ((MultiAttributeSetter)o2).mKey.attributeIndices.keySet().iterator();
                while (o1Keys.hasNext()) {
                    String key2;
                    String key1 = o1Keys.next();
                    int compare = key1.compareTo(key2 = o2Keys.next());
                    if (compare == 0) continue;
                    return compare;
                }
                Preconditions.checkState(false, "The sets don't match! That means the keys shouldn't match also");
            }
            for (String attribute : ((MultiAttributeSetter)o1).mKey.attributeIndices.keySet()) {
                ModelClass type2;
                int index1 = ((MultiAttributeSetter)o1).mKey.attributeIndices.get(attribute);
                int index2 = ((MultiAttributeSetter)o2).mKey.attributeIndices.get(attribute);
                ModelClass type1 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o1).mKey.parameterTypes[index1], null);
                if (type1.equals(type2 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o2).mKey.parameterTypes[index2], null))) continue;
                if (o1.mCasts[index1] != null) {
                    if (o2.mCasts[index2] != null) continue;
                    return 1;
                }
                if (o2.mCasts[index2] != null) {
                    return -1;
                }
                if (o1.mConverters[index1] != null) {
                    if (o2.mConverters[index2] != null) continue;
                    return 1;
                }
                if (o2.mConverters[index2] != null) {
                    return -1;
                }
                if (type1.isPrimitive()) {
                    if (type2.isPrimitive()) {
                        int type1ConversionLevel = ModelMethod.getImplicitConversionLevel(type1);
                        int type2ConversionLevel = ModelMethod.getImplicitConversionLevel(type2);
                        return type2ConversionLevel - type1ConversionLevel;
                    }
                    return -1;
                }
                if (type2.isPrimitive()) {
                    return 1;
                }
                if (type1.isAssignableFrom(type2)) {
                    return 1;
                }
                if (!type2.isAssignableFrom(type1)) continue;
                return -1;
            }
            return 0;
        }
    };

    private SetterStore(ModelAnalyzer modelAnalyzer, IntermediateV1 store) {
        this.mClassAnalyzer = modelAnalyzer;
        this.mStore = store;
    }

    public static SetterStore get(ModelAnalyzer modelAnalyzer) {
        if (sStore == null) {
            sStore = SetterStore.load(modelAnalyzer, SetterStore.class.getClassLoader());
        }
        return sStore;
    }

    private static SetterStore load(ModelAnalyzer modelAnalyzer, ClassLoader classLoader) {
        IntermediateV1 store = new IntermediateV1();
        List<Intermediate> previousStores = GenerationalClassUtil.loadObjects(classLoader, new GenerationalClassUtil.ExtensionFilter(SETTER_STORE_FILE_EXT));
        for (Intermediate intermediate : previousStores) {
            SetterStore.merge(store, intermediate);
        }
        return new SetterStore(modelAnalyzer, store);
    }

    public void addRenamedMethod(String attribute, String declaringClass, String method, TypeElement declaredOn) {
        HashMap<String, MethodDescription> renamed = this.mStore.renamedMethods.get(attribute = SetterStore.stripNamespace(attribute));
        if (renamed == null) {
            renamed = new HashMap();
            this.mStore.renamedMethods.put(attribute, renamed);
        }
        MethodDescription methodDescription = new MethodDescription(declaredOn.getQualifiedName().toString(), method);
        L.d("STORE addmethod desc %s", methodDescription);
        renamed.put(declaringClass, methodDescription);
    }

    public void addBindingAdapter(ProcessingEnvironment processingEnv, String attribute, ExecutableElement bindingMethod) {
        TypeMirror parameterType;
        String value;
        List<? extends VariableElement> parameters;
        TypeMirror viewType;
        String view;
        AccessorKey key;
        attribute = SetterStore.stripNamespace(attribute);
        L.d("STORE addBindingAdapter %s %s", attribute, bindingMethod);
        HashMap<AccessorKey, MethodDescription> adapters = this.mStore.adapterMethods.get(attribute);
        if (adapters == null) {
            adapters = new HashMap();
            this.mStore.adapterMethods.put(attribute, adapters);
        }
        if (adapters.containsKey(key = new AccessorKey(view = SetterStore.getQualifiedName(viewType = SetterStore.eraseType(processingEnv, (parameters = bindingMethod.getParameters()).get(0).asType())), value = SetterStore.getQualifiedName(parameterType = SetterStore.eraseType(processingEnv, parameters.get(1).asType()))))) {
            throw new IllegalArgumentException("Already exists!");
        }
        adapters.put(key, new MethodDescription(bindingMethod));
    }

    private static TypeMirror eraseType(ProcessingEnvironment processingEnv, TypeMirror typeMirror) {
        if (SetterStore.hasTypeVar(typeMirror)) {
            return processingEnv.getTypeUtils().erasure(typeMirror);
        }
        return typeMirror;
    }

    private static ModelClass eraseType(ModelClass modelClass) {
        if (SetterStore.hasTypeVar(modelClass)) {
            return modelClass.erasure();
        }
        return modelClass;
    }

    private static boolean hasTypeVar(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind == TypeKind.TYPEVAR) {
            return true;
        }
        if (kind == TypeKind.ARRAY) {
            return SetterStore.hasTypeVar(((ArrayType)typeMirror).getComponentType());
        }
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments == null || typeArguments.isEmpty()) {
                return false;
            }
            for (TypeMirror typeMirror2 : typeArguments) {
                if (!SetterStore.hasTypeVar(typeMirror2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean hasTypeVar(ModelClass type) {
        if (type.isTypeVar()) {
            return true;
        }
        if (type.isArray()) {
            return SetterStore.hasTypeVar(type.getComponentType());
        }
        List<ModelClass> typeArguments = type.getTypeArguments();
        if (typeArguments == null) {
            return false;
        }
        for (ModelClass arg : typeArguments) {
            if (!SetterStore.hasTypeVar(arg)) continue;
            return true;
        }
        return false;
    }

    public void addBindingAdapter(ProcessingEnvironment processingEnv, String[] attributes, ExecutableElement bindingMethod) {
        L.d("STORE add multi-value BindingAdapter %d %s", attributes.length, bindingMethod);
        MultiValueAdapterKey key = new MultiValueAdapterKey(processingEnv, bindingMethod, attributes);
        MethodDescription methodDescription = new MethodDescription(bindingMethod);
        this.mStore.multiValueAdapters.put(key, methodDescription);
    }

    private static String[] stripAttributes(String[] attributes) {
        String[] strippedAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            strippedAttributes[i] = SetterStore.stripNamespace(attributes[i]);
        }
        return strippedAttributes;
    }

    public void addUntaggableTypes(String[] typeNames, TypeElement declaredOn) {
        L.d("STORE addUntaggableTypes %s %s", Arrays.toString(typeNames), declaredOn);
        String declaredType = declaredOn.getQualifiedName().toString();
        for (String type : typeNames) {
            this.mStore.untaggableTypes.put(type, declaredType);
        }
    }

    private static String getQualifiedName(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case CHAR: 
            case FLOAT: 
            case DOUBLE: 
            case VOID: {
                return type.toString();
            }
            case ARRAY: {
                return SetterStore.getQualifiedName(((ArrayType)type).getComponentType()) + "[]";
            }
            case DECLARED: {
                return type.toString();
            }
        }
        return "-- no type --";
    }

    public void addConversionMethod(ExecutableElement conversionMethod) {
        L.d("STORE addConversionMethod %s", conversionMethod);
        List<? extends VariableElement> parameters = conversionMethod.getParameters();
        String fromType = SetterStore.getQualifiedName(parameters.get(0).asType());
        String toType = SetterStore.getQualifiedName(conversionMethod.getReturnType());
        MethodDescription methodDescription = new MethodDescription(conversionMethod);
        HashMap<String, MethodDescription> convertTo = this.mStore.conversionMethods.get(fromType);
        if (convertTo == null) {
            convertTo = new HashMap();
            this.mStore.conversionMethods.put(fromType, convertTo);
        }
        convertTo.put(toType, methodDescription);
    }

    public void clear(Set<String> classes) {
        ArrayList<AccessorKey> removedAccessorKeys = new ArrayList<AccessorKey>();
        for (HashMap<AccessorKey, MethodDescription> adapters : this.mStore.adapterMethods.values()) {
            for (AccessorKey accessorKey : adapters.keySet()) {
                MethodDescription description = adapters.get(accessorKey);
                if (!classes.contains(description.type)) continue;
                removedAccessorKeys.add(accessorKey);
            }
            SetterStore.removeFromMap(adapters, removedAccessorKeys);
        }
        ArrayList<String> removedRenamed = new ArrayList<String>();
        for (HashMap<String, MethodDescription> renamed : this.mStore.renamedMethods.values()) {
            for (String key : renamed.keySet()) {
                if (!classes.contains(renamed.get((Object)key).type)) continue;
                removedRenamed.add(key);
            }
            SetterStore.removeFromMap(renamed, removedRenamed);
        }
        ArrayList<String> removedConversions = new ArrayList<String>();
        for (HashMap hashMap : this.mStore.conversionMethods.values()) {
            for (String toType : hashMap.keySet()) {
                MethodDescription methodDescription = (MethodDescription)hashMap.get(toType);
                if (!classes.contains(methodDescription.type)) continue;
                removedConversions.add(toType);
            }
            SetterStore.removeFromMap(hashMap, removedConversions);
        }
        ArrayList<String> removedUntaggable = new ArrayList<String>();
        for (String typeName : this.mStore.untaggableTypes.keySet()) {
            if (!classes.contains(this.mStore.untaggableTypes.get(typeName))) continue;
            removedUntaggable.add(typeName);
        }
        SetterStore.removeFromMap(this.mStore.untaggableTypes, removedUntaggable);
    }

    private static <K, V> void removeFromMap(Map<K, V> map, List<K> keys) {
        for (K key : keys) {
            map.remove(key);
        }
        keys.clear();
    }

    public void write(String projectPackage, ProcessingEnvironment processingEnvironment) throws IOException {
        GenerationalClassUtil.writeIntermediateFile(processingEnvironment, projectPackage, projectPackage + SETTER_STORE_FILE_EXT, this.mStore);
    }

    private static String stripNamespace(String attribute) {
        int colon;
        if (!attribute.startsWith("android:") && (colon = attribute.indexOf(58)) >= 0) {
            attribute = attribute.substring(colon + 1);
        }
        return attribute;
    }

    public List<MultiAttributeSetter> getMultiAttributeSetterCalls(String[] attributes, ModelClass viewType, ModelClass[] valueType) {
        attributes = SetterStore.stripAttributes(attributes);
        ArrayList<MultiAttributeSetter> calls = new ArrayList<MultiAttributeSetter>();
        if (viewType != null && viewType.isGeneric()) {
            List<ModelClass> viewGenerics = viewType.getTypeArguments();
            for (int i = 0; i < valueType.length; ++i) {
                valueType[i] = SetterStore.eraseType(valueType[i], viewGenerics);
            }
            viewType = viewType.erasure();
        }
        ArrayList<MultiAttributeSetter> matching = this.getMatchingMultiAttributeSetters(attributes, viewType, valueType);
        Collections.sort(matching, this.COMPARE_MULTI_ATTRIBUTE_SETTERS);
        while (!matching.isEmpty()) {
            MultiAttributeSetter bestMatch = matching.get(0);
            calls.add(bestMatch);
            SetterStore.removeConsumedAttributes(matching, bestMatch.attributes);
        }
        return calls;
    }

    private static void removeConsumedAttributes(ArrayList<MultiAttributeSetter> matching, String[] attributes) {
        for (int i = matching.size() - 1; i >= 0; --i) {
            MultiAttributeSetter setter = matching.get(i);
            boolean found = false;
            for (String attribute : attributes) {
                if (!SetterStore.isInArray(attribute, setter.attributes)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            matching.remove(i);
        }
    }

    private static boolean isInArray(String str, String[] array) {
        for (String value : array) {
            if (!value.equals(str)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<MultiAttributeSetter> getMatchingMultiAttributeSetters(String[] attributes, ModelClass viewType, ModelClass[] valueType) {
        ArrayList<MultiAttributeSetter> setters = new ArrayList<MultiAttributeSetter>();
        for (MultiValueAdapterKey adapter : this.mStore.multiValueAdapters.keySet()) {
            MethodDescription method;
            MultiAttributeSetter setter;
            if (adapter.attributes.length > attributes.length) continue;
            ModelClass viewClass = this.mClassAnalyzer.findClass(adapter.viewType, null);
            if (viewClass.isGeneric()) {
                viewClass = viewClass.erasure();
            }
            if (!viewClass.isAssignableFrom(viewType) || (setter = this.createMultiAttributeSetter(method = this.mStore.multiValueAdapters.get(adapter), attributes, valueType, adapter)) == null) continue;
            setters.add(setter);
        }
        return setters;
    }

    private MultiAttributeSetter createMultiAttributeSetter(MethodDescription method, String[] allAttributes, ModelClass[] attributeValues, MultiValueAdapterKey adapter) {
        int matchingAttributes = 0;
        String[] casts = new String[adapter.attributes.length];
        MethodDescription[] conversions = new MethodDescription[adapter.attributes.length];
        for (int i = 0; i < allAttributes.length; ++i) {
            ModelClass attributeType;
            Integer index = adapter.attributeIndices.get(allAttributes[i]);
            if (index == null) continue;
            ++matchingAttributes;
            String parameterTypeStr = adapter.parameterTypes[index];
            ModelClass parameterType = SetterStore.eraseType(this.mClassAnalyzer.findClass(parameterTypeStr, null));
            if (parameterType.isAssignableFrom(attributeType = attributeValues[i]) || ModelMethod.isBoxingConversion(parameterType, attributeType) || ModelMethod.isImplicitConversion(attributeType, parameterType)) continue;
            conversions[index.intValue()] = this.getConversionMethod(attributeType, parameterType, null);
            if (conversions[index] != null) continue;
            if (attributeType.isObject()) {
                casts[index.intValue()] = parameterTypeStr;
                continue;
            }
            return null;
        }
        if (matchingAttributes != adapter.attributes.length) {
            return null;
        }
        return new MultiAttributeSetter(adapter, adapter.attributes, method, conversions, casts);
    }

    public SetterCall getSetterCall(String attribute, ModelClass viewType, ModelClass valueType, Map<String, String> imports) {
        attribute = SetterStore.stripNamespace(attribute);
        SetterCall setterCall = null;
        MethodDescription conversionMethod = null;
        if (viewType != null) {
            HashMap<AccessorKey, MethodDescription> adapters = this.mStore.adapterMethods.get(attribute);
            ModelMethod bestSetterMethod = this.getBestSetter(viewType, valueType, attribute, imports);
            ModelClass bestViewType = null;
            ModelClass bestValueType = null;
            if (bestSetterMethod != null) {
                bestViewType = bestSetterMethod.getDeclaringClass();
                bestValueType = bestSetterMethod.getParameterTypes()[0];
                setterCall = new ModelMethodSetter(bestSetterMethod);
            }
            if (adapters != null) {
                for (AccessorKey key : adapters.keySet()) {
                    try {
                        ModelClass adapterViewType = this.mClassAnalyzer.findClass(key.viewType, imports);
                        if (adapterViewType == null || !adapterViewType.isAssignableFrom(viewType)) continue;
                        try {
                            L.d("setter parameter type is %s", key.valueType);
                            ModelClass adapterValueType = SetterStore.eraseType(this.mClassAnalyzer.findClass(key.valueType, imports));
                            L.d("setter %s takes type %s, compared to %s", adapters.get((Object)key).method, adapterValueType.toJavaCode(), valueType.toJavaCode());
                            boolean isBetterView = bestViewType == null || bestValueType.isAssignableFrom(adapterValueType);
                            if (!this.isBetterParameter(valueType, adapterValueType, bestValueType, isBetterView, imports)) continue;
                            bestViewType = adapterViewType;
                            bestValueType = adapterValueType;
                            MethodDescription adapter = adapters.get(key);
                            setterCall = new AdapterSetter(adapter);
                        }
                        catch (Exception e) {
                            L.e(e, "Unknown class: %s", key.valueType);
                        }
                    }
                    catch (Exception e) {
                        L.e(e, "Unknown class: %s", key.viewType);
                    }
                }
            }
            conversionMethod = this.getConversionMethod(valueType, bestValueType, imports);
            if (valueType.isObject() && setterCall != null && bestValueType.isNullable()) {
                setterCall.setCast(bestValueType);
            }
        }
        if (setterCall == null) {
            if (viewType != null && !viewType.isViewDataBinding()) {
                L.e("Cannot find the setter for attribute '%s' on %s with parameter type %s.", attribute, viewType.getCanonicalName(), valueType.toJavaCode());
            }
            setterCall = new DummySetter(SetterStore.getDefaultSetter(attribute));
        }
        setterCall.setConverter(conversionMethod);
        return setterCall;
    }

    public boolean isUntaggable(String viewType) {
        return this.mStore.untaggableTypes.containsKey(viewType);
    }

    private ModelMethod getBestSetter(ModelClass viewType, ModelClass argumentType, String attribute, Map<String, String> imports) {
        if (viewType.isGeneric()) {
            argumentType = SetterStore.eraseType(argumentType, viewType.getTypeArguments());
            viewType = viewType.erasure();
        }
        ArrayList<String> setterCandidates = new ArrayList<String>();
        HashMap<String, MethodDescription> renamed = this.mStore.renamedMethods.get(attribute);
        if (renamed != null) {
            for (String className : renamed.keySet()) {
                try {
                    ModelClass renamedViewType = this.mClassAnalyzer.findClass(className, imports);
                    if (!renamedViewType.isAssignableFrom(viewType)) continue;
                    setterCandidates.add(renamed.get((Object)className).method);
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        setterCandidates.add(SetterStore.getDefaultSetter(attribute));
        setterCandidates.add(SetterStore.trimAttributeNamespace(attribute));
        ModelMethod bestMethod = null;
        ModelClass bestParameterType = null;
        ArrayList<ModelClass> args = new ArrayList<ModelClass>();
        args.add(argumentType);
        for (String name : setterCandidates) {
            ModelMethod[] methods;
            for (ModelMethod method : methods = viewType.getMethods(name, 1)) {
                ModelClass[] parameterTypes = method.getParameterTypes();
                ModelClass param = parameterTypes[0];
                if (!method.isVoid() || !this.isBetterParameter(argumentType, param, bestParameterType, true, imports)) continue;
                bestParameterType = param;
                bestMethod = method;
            }
        }
        return bestMethod;
    }

    private static ModelClass eraseType(ModelClass type, List<ModelClass> typeParameters) {
        List<ModelClass> typeArguments = type.getTypeArguments();
        if (typeArguments == null || typeParameters == null) {
            return type;
        }
        for (ModelClass arg : typeArguments) {
            if (!typeParameters.contains(arg)) continue;
            return type.erasure();
        }
        return type;
    }

    private static String trimAttributeNamespace(String attribute) {
        int colonIndex = attribute.indexOf(58);
        return colonIndex == -1 ? attribute : attribute.substring(colonIndex + 1);
    }

    private static String getDefaultSetter(String attribute) {
        return "set" + StringUtils.capitalize(SetterStore.trimAttributeNamespace(attribute));
    }

    private boolean isBetterParameter(ModelClass argument, ModelClass parameter, ModelClass oldParameter, boolean isBetterViewTypeMatch, Map<String, String> imports) {
        if (!isBetterViewTypeMatch && oldParameter.equals(argument)) {
            return false;
        }
        if (argument.equals(parameter)) {
            return true;
        }
        if (!isBetterViewTypeMatch && ModelMethod.isBoxingConversion(oldParameter, argument)) {
            return false;
        }
        if (ModelMethod.isBoxingConversion(parameter, argument)) {
            return true;
        }
        int oldConversionLevel = ModelMethod.getImplicitConversionLevel(oldParameter);
        if (ModelMethod.isImplicitConversion(argument, parameter)) {
            int conversionLevel = ModelMethod.getImplicitConversionLevel(parameter);
            return oldConversionLevel < 0 || conversionLevel < oldConversionLevel;
        }
        if (oldConversionLevel >= 0) {
            return false;
        }
        if (parameter.isAssignableFrom(argument)) {
            if (oldParameter == null) {
                return true;
            }
            return oldParameter.isAssignableFrom(parameter);
        }
        MethodDescription conversionMethod = this.getConversionMethod(argument, parameter, imports);
        if (conversionMethod != null) {
            return true;
        }
        if (this.getConversionMethod(argument, oldParameter, imports) != null) {
            return false;
        }
        return argument.isObject() && !parameter.isPrimitive();
    }

    private MethodDescription getConversionMethod(ModelClass from, ModelClass to, Map<String, String> imports) {
        if (from != null && to != null) {
            for (String fromClassName : this.mStore.conversionMethods.keySet()) {
                try {
                    ModelClass convertFrom = this.mClassAnalyzer.findClass(fromClassName, imports);
                    if (!this.canUseForConversion(from, convertFrom)) continue;
                    HashMap<String, MethodDescription> conversion = this.mStore.conversionMethods.get(fromClassName);
                    for (String toClassName : conversion.keySet()) {
                        try {
                            ModelClass convertTo = this.mClassAnalyzer.findClass(toClassName, imports);
                            if (!this.canUseForConversion(convertTo, to)) continue;
                            return conversion.get(toClassName);
                        }
                        catch (Exception e) {
                            L.d(e, "Unknown class: %s", toClassName);
                        }
                    }
                }
                catch (Exception e) {
                    L.d(e, "Unknown class: %s", fromClassName);
                }
            }
        }
        return null;
    }

    private boolean canUseForConversion(ModelClass from, ModelClass to) {
        return from.equals(to) || ModelMethod.isBoxingConversion(from, to) || to.isAssignableFrom(from);
    }

    private static void merge(IntermediateV1 store, Intermediate dumpStore) {
        IntermediateV1 intermediateV1 = (IntermediateV1)dumpStore.upgrade();
        SetterStore.merge(store.adapterMethods, intermediateV1.adapterMethods);
        SetterStore.merge(store.renamedMethods, intermediateV1.renamedMethods);
        SetterStore.merge(store.conversionMethods, intermediateV1.conversionMethods);
        store.multiValueAdapters.putAll(intermediateV1.multiValueAdapters);
        store.untaggableTypes.putAll(intermediateV1.untaggableTypes);
    }

    private static <K, V> void merge(HashMap<K, HashMap<V, MethodDescription>> first, HashMap<K, HashMap<V, MethodDescription>> second) {
        for (K key : second.keySet()) {
            HashMap<MethodDescription, MethodDescription> firstVals = first.get(key);
            HashMap<V, MethodDescription> secondVals = second.get(key);
            if (firstVals == null) {
                first.put(key, secondVals);
                continue;
            }
            for (V key2 : secondVals.keySet()) {
                if (firstVals.containsKey(key2)) continue;
                firstVals.put((MethodDescription)key2, secondVals.get(key2));
            }
        }
    }

    public static class MultiAttributeSetter
    implements BindingSetterCall {
        public final String[] attributes;
        private final MethodDescription mAdapter;
        private final MethodDescription[] mConverters;
        private final String[] mCasts;
        private final MultiValueAdapterKey mKey;

        public MultiAttributeSetter(MultiValueAdapterKey key, String[] attributes, MethodDescription adapter, MethodDescription[] converters, String[] casts) {
            Preconditions.checkArgument(converters != null && converters.length == attributes.length && casts != null && casts.length == attributes.length);
            this.attributes = attributes;
            this.mAdapter = adapter;
            this.mConverters = converters;
            this.mCasts = casts;
            this.mKey = key;
        }

        @Override
        public final String toJava(String viewExpression, String[] valueExpressions) {
            Preconditions.checkArgument(valueExpressions.length == this.attributes.length, "MultiAttributeSetter needs %s items, received %s", Arrays.toString(this.attributes), Arrays.toString(valueExpressions));
            StringBuilder sb = new StringBuilder();
            sb.append(this.mAdapter.type).append('.').append(this.mAdapter.method).append('(').append(viewExpression);
            for (int i = 0; i < valueExpressions.length; ++i) {
                sb.append(',');
                if (this.mConverters[i] != null) {
                    MethodDescription converter = this.mConverters[i];
                    sb.append(converter.type).append('.').append(converter.method).append('(').append(valueExpressions[i]).append(')');
                    continue;
                }
                if (this.mCasts[i] != null) {
                    sb.append('(').append(this.mCasts[i]).append(')');
                }
                sb.append(valueExpressions[i]);
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        public String toString() {
            return "MultiAttributeSetter{attributes=" + Arrays.toString(this.attributes) + ", mAdapter=" + this.mAdapter + ", mConverters=" + Arrays.toString(this.mConverters) + ", mCasts=" + Arrays.toString(this.mCasts) + ", mKey=" + this.mKey + '}';
        }
    }

    public static abstract class SetterCall
    implements BindingSetterCall {
        private MethodDescription mConverter;
        protected String mCastString = "";

        public void setConverter(MethodDescription converter) {
            this.mConverter = converter;
        }

        protected abstract String toJavaInternal(String var1, String var2);

        @Override
        public final String toJava(String viewExpression, String ... valueExpression) {
            Preconditions.checkArgument(valueExpression.length == 1);
            return this.toJavaInternal(viewExpression, this.convertValue(valueExpression[0]));
        }

        protected String convertValue(String valueExpression) {
            return this.mConverter == null ? valueExpression : this.mConverter.type + "." + this.mConverter.method + "(" + valueExpression + ")";
        }

        @Override
        public abstract int getMinApi();

        public void setCast(ModelClass castTo) {
            this.mCastString = "(" + castTo.toJavaCode() + ") ";
        }
    }

    public static interface BindingSetterCall {
        public String toJava(String var1, String ... var2);

        public int getMinApi();
    }

    public static class ModelMethodSetter
    extends SetterCall {
        final ModelMethod mModelMethod;

        public ModelMethodSetter(ModelMethod modelMethod) {
            this.mModelMethod = modelMethod;
        }

        @Override
        public String toJavaInternal(String viewExpression, String valueExpression) {
            return viewExpression + "." + this.mModelMethod.getName() + "(" + this.mCastString + valueExpression + ")";
        }

        @Override
        public int getMinApi() {
            return this.mModelMethod.getMinApi();
        }
    }

    public static class AdapterSetter
    extends SetterCall {
        final MethodDescription mAdapter;

        public AdapterSetter(MethodDescription adapter) {
            this.mAdapter = adapter;
        }

        @Override
        public String toJavaInternal(String viewExpression, String valueExpression) {
            return this.mAdapter.type + "." + this.mAdapter.method + "(" + viewExpression + ", " + this.mCastString + valueExpression + ")";
        }

        @Override
        public int getMinApi() {
            return 1;
        }
    }

    public static class DummySetter
    extends SetterCall {
        private String mMethodName;

        public DummySetter(String methodName) {
            this.mMethodName = methodName;
        }

        @Override
        public String toJavaInternal(String viewExpression, String valueExpression) {
            return viewExpression + "." + this.mMethodName + "(" + valueExpression + ")";
        }

        @Override
        public int getMinApi() {
            return 1;
        }
    }

    private static class IntermediateV1
    implements Serializable,
    Intermediate {
        private static final long serialVersionUID = 1L;
        public final HashMap<String, HashMap<AccessorKey, MethodDescription>> adapterMethods = new HashMap();
        public final HashMap<String, HashMap<String, MethodDescription>> renamedMethods = new HashMap();
        public final HashMap<String, HashMap<String, MethodDescription>> conversionMethods = new HashMap();
        public final HashMap<String, String> untaggableTypes = new HashMap();
        public final HashMap<MultiValueAdapterKey, MethodDescription> multiValueAdapters = new HashMap();

        @Override
        public Intermediate upgrade() {
            return this;
        }
    }

    private static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();
    }

    private static class AccessorKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String viewType;
        public final String valueType;

        public AccessorKey(String viewType, String valueType) {
            this.viewType = viewType;
            this.valueType = valueType;
        }

        public int hashCode() {
            return Objects.hash(this.viewType, this.valueType);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AccessorKey) {
                AccessorKey that = (AccessorKey)obj;
                return this.viewType.equals(that.valueType) && this.valueType.equals(that.valueType);
            }
            return false;
        }

        public String toString() {
            return "AK(" + this.viewType + ", " + this.valueType + ")";
        }
    }

    private static class MethodDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String type;
        public final String method;

        public MethodDescription(String type, String method) {
            this.type = type;
            this.method = method;
            L.d("BINARY created method desc 1 %s %s", type, method);
        }

        public MethodDescription(ExecutableElement method) {
            TypeElement enclosingClass = (TypeElement)method.getEnclosingElement();
            this.type = enclosingClass.getQualifiedName().toString();
            this.method = method.getSimpleName().toString();
            L.d("BINARY created method desc 2 %s %s, %s", this.type, this.method, method);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodDescription) {
                MethodDescription that = (MethodDescription)obj;
                return that.type.equals(this.type) && that.method.equals(this.method);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.method);
        }

        public String toString() {
            return this.type + "." + this.method + "()";
        }
    }

    private static class MultiValueAdapterKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String viewType;
        public final String[] attributes;
        public final String[] parameterTypes;
        public final TreeMap<String, Integer> attributeIndices = new TreeMap();

        public MultiValueAdapterKey(ProcessingEnvironment processingEnv, ExecutableElement method, String[] attributes) {
            this.attributes = SetterStore.stripAttributes(attributes);
            List<? extends VariableElement> parameters = method.getParameters();
            this.viewType = SetterStore.getQualifiedName(SetterStore.eraseType(processingEnv, parameters.get(0).asType()));
            this.parameterTypes = new String[parameters.size() - 1];
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                TypeMirror typeMirror = SetterStore.eraseType(processingEnv, parameters.get(i + 1).asType());
                this.parameterTypes[i] = SetterStore.getQualifiedName(typeMirror);
                this.attributeIndices.put(this.attributes[i], i);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiValueAdapterKey)) {
                return false;
            }
            MultiValueAdapterKey that = (MultiValueAdapterKey)obj;
            if (!this.viewType.equals(that.viewType) || this.attributes.length != that.attributes.length || !this.attributeIndices.keySet().equals(that.attributeIndices.keySet())) {
                return false;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                String thisParameter = this.parameterTypes[i];
                int thatIndex = that.attributeIndices.get(this.attributes[i]);
                String thatParameter = that.parameterTypes[thatIndex];
                if (thisParameter.equals(thatParameter)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.viewType, this.attributeIndices.keySet());
        }
    }
}

