/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.DataInputStream;
import java.io.IOException;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.Attribute;

public class BootstrapMethodsAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "BootstrapMethods";

    public BootstrapMethodsAttribute(ConstantPool cp) {
        super(cp.addUtf8Info(ATTRIBUTE_NAME).getEntryIndex());
        this.setConstantPool(cp);
    }

    public BootstrapMethodsAttribute(ConstantPool constantPool, short nameIndex, int attribute_length, DataInputStream dis) throws IOException {
        super(nameIndex, attribute_length, dis);
    }

    public BootstrapMethod[] getBootstrapMethods() throws IOException {
        DataInputStream dis = this.getDataInputStream();
        short num_bootstrap_mehtods = dis.readShort();
        BootstrapMethod[] bma = new BootstrapMethod[num_bootstrap_mehtods];
        for (int i = 0; i < bma.length; ++i) {
            short bootstrap_method_ref = dis.readShort();
            int num_bootstrap_arguments = dis.readShort();
            short[] bootstrap_arguments = new short[num_bootstrap_arguments];
            for (int j = 0; j < num_bootstrap_arguments; ++j) {
                bootstrap_arguments[j] = dis.readShort();
            }
            bma[i] = new BootstrapMethod(bootstrap_method_ref, bootstrap_arguments);
        }
        return bma;
    }

    public class BootstrapMethod {
        private short bootstrap_method_ref;
        private final short[] bootstrap_arguments;

        BootstrapMethod(short bootstrap_method_ref, short[] bootstrap_arguments) {
            this.bootstrap_method_ref = bootstrap_method_ref;
            this.bootstrap_arguments = bootstrap_arguments;
        }

        public ConstantPool.MethodRefInfo getMethodRefInfo() {
            return (ConstantPool.MethodRefInfo)BootstrapMethodsAttribute.this.cp.get(this.bootstrap_method_ref);
        }

        public ConstantPool.Entry[] getArguments() {
            ConstantPool.Entry[] entries = new ConstantPool.Entry[this.bootstrap_arguments.length];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = BootstrapMethodsAttribute.this.cp.get(this.bootstrap_arguments[i]);
            }
            return entries;
        }
    }
}

