/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.Installer;
import java.awt.Font;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class InstallContext {
    private File outputDir;
    private boolean hasGui;
    public File javaPath;
    public File toolsJarPath;
    public Installer installer;
    private Map properties;
    static final String[] TEXT_EXTENSIONS = new String[]{".txt", ".text", ".htm", ".html", ".java", ".ajava", "README", ".lst"};
    static final String OVERWRITE_MESSAGE = "Overwrite file ";
    static final String OVERWRITE_TITLE = "Overwrite?";
    static final String[] OVERWRITE_OPTIONS = new String[]{"Yes", "No", "Yes to all"};
    static final int OVERWRITE_YES = 0;
    static final int OVERWRITE_NO = 1;
    static final int OVERWRITE_ALL = 2;
    int overwriteState = 1;

    public InstallContext(Map properties) {
        this.properties = properties;
        properties.put("user.home", System.getProperty("user.home"));
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
        this.properties.put("installer.output.dir", outputDir.getAbsolutePath());
        this.properties.put("installer.output.dir.bin", new File(outputDir, "bin").getAbsolutePath());
        this.properties.put("installer.output.dir.doc", new File(outputDir, "doc").getAbsolutePath());
        this.properties.put("installer.output.aspectjrt", new File(new File(outputDir, "lib"), "aspectjrt.jar").getAbsolutePath());
        this.properties.put("installer.output.readme", new File(outputDir, this.installer.getReadmeFilename()).getAbsolutePath());
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public boolean hasGui() {
        return this.hasGui;
    }

    public void setHasGui(boolean hasGui) {
        if (this.hasGui != hasGui) {
            this.hasGui = hasGui;
        }
    }

    public Font getFont() {
        return new Font("Serif", 0, 14);
    }

    public String getOS() {
        return System.getProperty("os.name");
    }

    public boolean onOS2() {
        return this.getOS().equals("OS2") || this.getOS().equals("OS/2");
    }

    public boolean onWindows() {
        return this.getOS().startsWith("Windows") || this.onOS2();
    }

    public boolean onWindowsPro() {
        return this.getOS().equals("Windows NT") || this.getOS().equals("Windows 2000") || this.getOS().equals("Windows XP") || this.getOS().equals("Windows Vista") || this.getOS().equals("Windows 7");
    }

    public boolean onMacintosh() {
        return this.getOS().startsWith("Mac");
    }

    public boolean onUnix() {
        return !this.onWindows();
    }

    public boolean isTextFile(File file) {
        String name = file.getName();
        for (int i = 0; i < TEXT_EXTENSIONS.length; ++i) {
            if (!name.endsWith(TEXT_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }

    public void handleException(Throwable e) {
        System.out.println("internal error: " + e.toString());
        e.printStackTrace();
        if (this.hasGui()) {
            JOptionPane.showMessageDialog(this.installer.frame, e.toString(), "Unexpected Exception", 0);
        }
    }

    boolean shouldOverwrite(final File file) {
        if (this.overwriteState == 2) {
            return true;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int ret;
                    InstallContext.this.overwriteState = ret = JOptionPane.showOptionDialog(InstallContext.this.installer.frame, InstallContext.OVERWRITE_MESSAGE + file.getPath(), InstallContext.OVERWRITE_TITLE, 1, 3, null, OVERWRITE_OPTIONS, OVERWRITE_OPTIONS[0]);
                }
            });
        }
        catch (InvocationTargetException ite) {
            this.handleException(ite.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.overwriteState == 0 || this.overwriteState == 2;
    }

    public Map getProperties() {
        return this.properties;
    }
}

