#ifndef ATL_ctGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='LOWER'
 * M : 25,50,75,100,125,150,175,200,250,300,350,400,450,500,600,700,800,900,1000,1200,1400,1600,1800,2000,2400,2800,3200,3600,4000
 * N : 25,50,75,100,125,150,175,200,250,300,350,400,450,500,600,700,800,900,1000,1200,1400,1600,1800,2000,2400,2800,3200,3600,4000
 * NB : 1,8,12,16,12,12,32,20,20,24,16,20,20,16,16,16,24,24,24,24,24,24,24,24,24,24,24,24,28
 */
#define ATL_ctGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 37) (nb_) = 1; \
   else if ((n_) < 62) (nb_) = 8; \
   else if ((n_) < 87) (nb_) = 12; \
   else if ((n_) < 112) (nb_) = 16; \
   else if ((n_) < 162) (nb_) = 12; \
   else if ((n_) < 187) (nb_) = 32; \
   else if ((n_) < 275) (nb_) = 20; \
   else if ((n_) < 325) (nb_) = 24; \
   else if ((n_) < 375) (nb_) = 16; \
   else if ((n_) < 475) (nb_) = 20; \
   else if ((n_) < 750) (nb_) = 16; \
   else if ((n_) < 3800) (nb_) = 24; \
   else (nb_) = 28; \
}


#endif    /* end ifndef ATL_ctGetNB_geqrf */
