# Ctest script for packaging nightly CamiTK
# To configure a Nightly packaging, create a cron job using this script "ctest -S this-script.cmake -V"
#
# What this script does ?
# * INFORMATION STEP
#       Configure SITE and BUILD information to be correctly display on dashboard
#       Loads information from the CTestConfig.cmake file.
# * UPDATE STEP
#       use svn to udpdate source code to the latest revision BEFORE Nightly start time, which is defined in the CTestConfig.cmake file.
# * CONFIGURE STEP
#       configure the whole CamiTK project and create a new build directory 
# * BUILD STEP 
#       build each subproject of CamiTK
# For each step a report is sent to the dashboard. This allows any developer to be informed (mailing list) of any problem, even BEFORE the script ends !

# Need to be defined, for the build to run.
set(CTEST_SOURCE_DIRECTORY "C:/dev/CamiTK/opensource/camitk/src")
set(CTEST_BINARY_DIRECTORY "C:/dev/CamiTK/opensource/camitk/build_package")

# NSIS makensis.exe program to be defined for the windows packaging
set(MAKENSIS_PATH "C:/dev/NSIS/makensis.exe")

# Script configuration, depending of the build, computer running the script
# Update to feat each computer which runs this script
set( CTEST_SITE "MANNONI-WIN7-32")
set( CTEST_BUILD_NAME "WIN7-32-Package")
set( CTEST_CMAKE_GENERATOR  "MinGW Makefiles")
set( CTEST_BUILD_CONFIGURATION "Release")

# Update source code and send reports
# set( CTEST_UPDATE_COMMAND "svn")
find_program(CTEST_SVN_COMMAND svn)
set( CTEST_UPDATE_COMMAND ${CTEST_SVN_COMMAND})

# CMake configuration (put here all the configure flags)
set( CTEST_CONFIGURE_COMMAND "${CMAKE_COMMAND} -G \"${CTEST_CMAKE_GENERATOR}\"")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCMAKE_BUILD_TYPE:STRING=${CTEST_BUILD_CONFIGURATION}")
# CamiTK install location, CPack requires a relative path
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCAMITK_INSTALL_ROOT:PATH=.")
# CPack packaging target
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_NSIS:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DMAKENSIS:STRING=${MAKENSIS_PATH}")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_ZIP:BOOL=FALSE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_SOURCE_ZIP:BOOL=FALSE")
# CEP preferences
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCEP_IMAGING:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCEP_MODELING:BOOL=TRUE")
# Source files
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} ${CTEST_SOURCE_DIRECTORY}")

# to get CDash server configuration :
include("${CTEST_SOURCE_DIRECTORY}/../CTestConfig.cmake")

# The type of build that this script will make 
# For this script we use Nightly build has it is designed to be run once a day
ctest_start(Nightly)

# Update source code
ctest_update(SOURCE ${CTEST_SOURCE_DIRECTORY})
ctest_submit(PARTS Update Notes)

# Configure whole project
ctest_empty_binary_directory(${CTEST_BINARY_DIRECTORY})
ctest_configure()
ctest_submit(PARTS Configure)

# to get subprojects listing (automatically created at confituration step)
include("${CTEST_BINARY_DIRECTORY}/Subprojects.cmake")

# Update CDash configuration to the server
# Project.xml file is automatically generated. If someone added an extension to CamiTK, CDash will automatically be updated according to it.
# To do this, send this file to the server
# ctest_submit(FILES "${CTEST_BINARY_DIRECTORY}/Project.xml") 

# Packaging
# tag the corresponding subproject to match corresponding CDash's one.
set_property(GLOBAL PROPERTY SubProject package)
set_property(GLOBAL PROPERTY Label package)
# Package CamiTK and send the report.
set(CTEST_BUILD_TARGET camitk_package)
ctest_build()
ctest_submit(PARTS Build)

