#!
#! This CMake file run a command and put the output in
#! a given file
#! \note
#! You have to call camitk_test_init(..) first to prepare all variables
# Description: compare two files with the same name but not present in the same directory. The two full paths are provided by pre-edited variables
# Inspired from http://stackoverflow.com/questions/3305545/how-to-adapt-my-unit-tests-to-cmake-and-ctest
# and http://www.cmake.org/pipermail/cmake/2009-July/030619.html

# declare outputfiles
get_filename_component(OUTFILE ${CAMITK_TEST_PASS_FILE} NAME )
set(CAMITK_TEST_COMMAND_OUTPUT_FILE ${CAMITK_TEST_OUTPUT_DIR}/${OUTFILE}) # the output of the tested command goes in this files
# message( "CAMITK_TEST_COMMAND_OUTPUT_FILE " ${CAMITK_TEST_COMMAND_OUTPUT_FILE} )
# remove previous savings
execute_process(COMMAND ${CMAKE_COMMAND} -E remove -f ${CAMITK_TEST_COMMAND_OUTPUT_FILE} )
# expands all arguments
set( CAMITK_TEST_COMMAND_ARG "${CAMITK_TEST_COMMAND_ARG} -o ${CAMITK_TEST_OUTPUT_DIR}" ) #space before -o is important here  #-o is the directory where the output file will be saved
string(REPLACE " " ";" CAMITK_TEST_COMMAND_ARG_LIST ${CAMITK_TEST_COMMAND_ARG})
execute_process(
  COMMAND ${CAMITK_TEST_COMMAND} ${CAMITK_TEST_COMMAND_ARG_LIST})

# Then compare the files
execute_process(
  COMMAND ${CMAKE_COMMAND} -E compare_files ${CAMITK_TEST_PASS_FILE} ${CAMITK_TEST_COMMAND_OUTPUT_FILE}
  RESULT_VARIABLE CAMITK_TEST_PASS_FILE_RESULT
  )

# check result
if( CAMITK_TEST_PASS_FILE_RESULT )
  message(SEND_ERROR "${CAMITK_TEST_NAME}: ${CAMITK_TEST_COMMAND_OUTPUT_FILE} does not match ${CAMITK_TEST_PASS_FILE}" )
endif()