{
  Copyright 2014-2023 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Unique identifiers for achievements and leaderboards. }
unit GameIds;

interface

uses CastleGameService;

const
  { Achievement ids.
    For Android: these are generated by creating achievements in Google Developer Console.
    For iOS: these are set by you in iTunes Connect. }
  AchievementMove        = {$ifdef ANDROID} 'CgkI3pHW2dgJEAIQAA' {$else} 'move'         {$endif};
  AchievementClickFollow = {$ifdef ANDROID} 'CgkI3pHW2dgJEAIQAQ' {$else} 'click_follow' {$endif};
  AchievementSeeLeft     = {$ifdef ANDROID} 'CgkI3pHW2dgJEAIQAg' {$else} 'see_left'     {$endif};
  AchievementSeeRight    = {$ifdef ANDROID} 'CgkI3pHW2dgJEAIQAw' {$else} 'see_right'    {$endif};

  { Leaderboard ids.
    For Android: these are generated by creating leaderboards in Google Developer Console.
    For iOS: these are set by you in iTunes Connect. }
  LeaderboardRandomScores = {$ifdef ANDROID} 'CgkI3pHW2dgJEAIQBA' {$else} 'random_scores' {$endif};
  LeaderboardTimes = {$ifdef ANDROID} 'CgkI3pHW2dgJEAIQBQ' {$else} 'times' {$endif};

var
  GameService: TGameService;

  { For achievements that can be detected *very* often (e.g. AchievementSeeLeft
    would be submitted 60x per second, if the dragon is on the left side of the world)
    you can use a flag to not send GameService.Achievement multiple times with the same value.

    This is only an optimization, to not overwhelm the GameService with useless calls.
    Sending the same achievement many times would be ignored anyway. }
  AchievementSeeLeftSubmitted, AchievementSeeRightSubmitted: boolean;

implementation

end.
