Memcache
========

_Library for memcached protocol_

Author: Kevin Rosenberg <kevin@rosenberg.net>, based on the
`cl-memcached` library by Abhijit 'quasi' Rao and 
Chaitanya Gupta .

Date Started: July 1, 2011

Overview
--------

This package is based on the `cl-memcached` library.  It is
substantially modified for use with the
[memstore](http://memstore.b9.com) library. The primary areas of
additional functionality are:

* Support for flags field with get and set functions.
  This is required as memstore stores bit flags denoting
  how the data is serialized. That information is required
  to deserialize the data.

* Support for additional memcached functionality, such as
  the gets command for retrieving CAS identifiers. The CAS
  unique ID is used for the added `:cas` storage command.
  Other storage commands newly supported are `:append` and 
  `:prepend`.

* All communication now uses `mc-send-command` function with
  transparently supports writing strings with `write-byte`.
  This allows `usocket` to be used on other Lisp implementations
  besides AllegroCL. Because cl-memcached used `write-string`
  with usocket-stream, only AllegroCL was supported.
  By sending all data as (unsigned-byte 8), all Lisp implementions
  supported by `usocket` are now supported with `memcached`.

* Encapsulated reading and writing to socket stream to avoid
  handling \\#return characters in high-level code.

* Changes to support the change in statistics fields with membase.
  Some fields were no longer present. Also, membase 1.7 has
  187 statistics fields versus the 20 fields supported in
  `cl-memcached`. New function `mc-get-stat` allows to retrieving
  any statistics field by name.

* More robust `print-object` functions to avoid errors if fields
  in statistics are not present.

* Removed compatibility functions in `compat.lisp` by using the
  [`kmrcl`](http://gitpub.b9.com/kmrcl.git) library to provide those
  functions as well as utilitizing other `kmrcl` functions to simplify
  code.

* Added functions to support all memcached API commands,
  such as `flush_all` and `version`.

* Support for the `moreply` command argument accepted by
  many commands.

* Support the `noreply` argument that many API commands accept.

* Write nearly the entire code base for improved
  clarity, robustness, and efficiency.
