/****************************************************************************
 *    lib/c/Identifier.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Identifier.h"

using namespace C;

//Identifier::Identifier() {}

Identifier::Identifier(string* name) {
	name_ = *name;
	delete name;
	args_ = NULL;
}

Identifier::Identifier(string* name, Arguments* args) {
	name_ = *name;
	args_ = args;
}

Identifier::~Identifier() {
	delete args_;
}

string Identifier::getName() {
	return name_;
}

/**
 * @return vector<Variable*>
 */
set<Variable*>* Identifier::getVariables ( ) {
	if(args_) return args_->getVariables();
	else return new set<Variable*>();
}

