/* $Id: hdrl_combine.h,v 1.3 2013-10-16 16:52:20 cgarcia Exp $
 *
 * This file is part of the HDRL
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-10-16 16:52:20 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef HDRL_COMBINE_H
#define HDRL_COMBINE_H

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include "hdrl_iter.h"
#include "hdrl_collapse.h"
#include <cpl.h>

/*-----------------------------------------------------------------------------
                                Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                            Functions prototypes
 -----------------------------------------------------------------------------*/
CPL_BEGIN_DECLS
cpl_error_code
hdrl_imagelist_combine(const cpl_imagelist * data, const cpl_imagelist * errors,
                      hdrl_collapse_imagelist_to_image_t * method,
                      cpl_image ** out, cpl_image ** err, cpl_image ** contrib);

cpl_error_code
hdrl_imagelist_combine_it(hdrl_iter_t * imgit,
                         hdrl_iter_t * errit,
                         hdrl_collapse_imagelist_to_image_t * method,
                         hdrl_iter_t * oimgit,
                         hdrl_iter_t * oerrit,
                         hdrl_iter_t * ocontribit);
CPL_END_DECLS

/*-----------------------------------------------------------------------------
             Private declarations - must not be used outside of hdrl
 -----------------------------------------------------------------------------*/

#ifdef HDRL_USE_PRIVATE

#endif

#endif
