'\"
'\" Generated from file 'critcl_callback\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2011-2018 Andreas Kupries
'\"
.TH "critcl::callback" n 0\&.1 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl::callback \- CriTcl C-level Callback Utilities
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBcritcl  ?3\&.1?\fR
.sp
package require \fBcritcl::callback  ?0\&.1?\fR
.sp
\fBcritcl_callback_p\fR \fBcritcl_callback_new\fR \fIinterp\fR \fIobjc\fR \fIobjv\fR \fInargs\fR
.sp
\fBvoid\fR \fBcritcl_callback_extend\fR \fIcallback\fR \fIargument\fR
.sp
\fBvoid\fR \fBcritcl_callback_destroy\fR \fIcallback\fR
.sp
\fBint\fR \fBcritcl_callback_invoke\fR \fIcallback\fR \fIobjc\fR \fIobjv\fR
.sp
.BE
.SH DESCRIPTION
.PP
\fIC Runtime In Tcl\fR, or \fICriTcl\fR , is a system for compiling C code
embedded in Tcl on the fly and either loading the resulting objects into Tcl for
immediate use or packaging them for distribution\&.  Use \fICriTcl\fR to improve
performance by rewriting in C those routines that are performance bottlenecks\&.
.PP
This document is the reference manpage for the
\fBcritcl::callback\fR package\&.
This package provides, via a stubs API table, data structures and
functions to manage callbacks from C to Tcl\&. The package has no
Tcl-level facilities\&.
Its intended audience are mainly developers wishing to write Tcl
packages with embedded C code who have to invoke user-specified
command (prefixes) in Tcl\&.
.PP
This package resides in the Support Package Layer of CriTcl\&.
.PP
.PS
.nf
+----------------+
|Applications    |
| critcl         |
| critcl::app    |
+----------------+

+----------------+
|Core Packages   |
| critcl         |
| critcl::util   |
+----------------+

*================*
|Support Packages|
| stubs::*       |
| md5, platform  |
|  \&.\&.\&.           |
*================*

.fi
.PE
.PP
.SH API
The package API consist of one opaque data structure
(\fBcritcl_callback_p\fR) and four functions operating on the same\&.
These functions are
.TP
\fBcritcl_callback_p\fR \fBcritcl_callback_new\fR \fIinterp\fR \fIobjc\fR \fIobjv\fR \fInargs\fR
This function creates a new callback (manager) and returns it as its result\&.
.sp
The callback is initialized with the Tcl_Interp* \fIinterp\fR
specifying where to run the callback, the fixed part of the command to
run in standard \fIobjc\fR/\fIobjv\fR notation, plus the number of
free arguments to expect after the fixed part\&.
.sp
The fixed part is the essentially the command prefix of the callback\&.
.sp
All \fBTcl_Obj*\fR elements of \fIobjv\fR are protected against early
release by incrementing their reference counts\&. The callback
effectively takes ownership of these objects\&.
.TP
\fBvoid\fR \fBcritcl_callback_extend\fR \fIcallback\fR \fIargument\fR
This function takes a \fIcallback\fR of type \fBcritcl_callback_p\fR
and extends its fixed part with the \fIargument\fR, taking the first
free slot for arguments to do so\&.
This means that after the application of this function the specified
callback has one free argument less\&.
.sp
With assertions active attempting to extend beyond the number of free
arguments will cause a panic\&. Without assertions active expect a crash
at some point\&.
.sp
This allows the user to extend the fixed part of the callback with
semi-fixed elements, like method names (See \fBMultiple methods\fR)\&.
.sp
The \fIargument\fR is protected against early release by incrementing
its reference count\&. The callback effectively takes ownership of this
object\&.
.TP
\fBvoid\fR \fBcritcl_callback_destroy\fR \fIcallback\fR
This function takes a \fIcallback\fR of type \fBcritcl_callback_p\fR
and releases all memory associated with it\&.
After application of this function the callback cannot be used anymore\&.
.sp
All fixed elements of the callback (owned by it) are released by
decrementing their reference counts\&.
.TP
\fBint\fR \fBcritcl_callback_invoke\fR \fIcallback\fR \fIobjc\fR \fIobjv\fR
This function invokes the callback in the Tcl interpreter specified at
the time of construction, in the global level and namespace, with the
free arguments filled by the \fBTcl_Obj*\fR objects specified via
\fIobjc\fR/\fIobjv\fR\&.
.sp
It returns the Tcl status of the invoked command as its result\&.
Any further results or error messages will be found in the result area
of the Tcl interpreter in question\&. The exact nature of such is
dependent on the callback itself\&.
.sp
With assertions active attempting to use more arguments than available
will cause a panic\&. Without assertions active expect a crash at some
point\&.
.sp
While the callback is running all \fBTcl_Obj*\fR elements of the
command, fixed and arguments, are protected against early release by
temporarily incrementing their reference counts\&.
.PP
.SH EXAMPLES
.SS "SIMPLE CALLBACK"
The example here shows the important parts of using the functions of
this package for a simple callback which is invoked with a single
argument, some kind of data to hand to the Tcl level\&.
.CS


    // Create the callback with interpreter and command prefix in
    // oc/ov, plus space for the argument
    critcl_callback_p cb = critcl_callback_new (interp, oc, ov, 1);

    // Invoke the callback somewhere in the C package using this one,
    // with Tcl_Obj* data holding the information to pass up\&.
    critcl_callback_invoke (cb, 1, &data);

    // At the end of the lifetime, release the callback\&.
    critcl_callback_destroy (cb);

.CE
Note that the functions of this package are designed for the case
where the created callback (\fBcb\fR above) is kept around for a
long time, and many different invokations\&.
.PP
Using the sequence above as is, creating and destroying the callback
each time it is invoked will yield very poor performance and lots of
undesirable memory churn\&.
.SS "MULTIPLE METHODS"
While we can use the methodology of the previous section when a single
(Tcl-level) callback is invoked from different places in C, with
different methods, simply having another argument slot and filling it
an invokation time with the method object, a second methodology is
open to us due to \fBcritcl_callback_extend\fR\&.
.CS



    // Create one callback manager per different method the callback
    // will be used with\&. Fill the first of the two declared arguments
    // with the different methods\&.
    critcl_callback_p cb_a = critcl_callback_new (interp, oc, ov, 2);
    critcl_callback_p cb_b = critcl_callback_new (interp, oc, ov, 2);

    critcl_callback_extend (cb_a, Tcl_NewStringObj ("method1", -1));
    critcl_callback_extend (cb_b, Tcl_NewStringObj ("method2", -1));

    // After the extension we have one free argument left, for use in
    // the invokations\&.

    critcl_callback_invoke (cb_a, 1, &dataX);

    critcl_callback_invoke (cb_b, 1, &dataY);


    // At the end release both managers again
    critcl_callback_destroy (cb_a);
    critcl_callback_destroy (cb_b);

.CE
The nice thing here is that the method objects are allocated only once
and automatically shared by all the calls\&. No memory churn to
repeatedly allocate the same string objects over and over again\&.
.SH AUTHORS
Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such at \fIhttps://github\&.com/andreas-kupries/critcl\fR\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
C code, Embedded C Code, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, on demand compilation, on-the-fly compilation
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) 2011-2018 Andreas Kupries

.fi
