#ifndef _ACCEPTOR_H
#define _ACCEPTOR_H

#include <netinet/in.h>

#include "thread.h"

enum SocketType {
	TCP_SOCKET,
	UDP_SOCKET,
};
int create_server_socket(const sockaddr_in6 &addr, SocketType socket_type);

class AcceptorProto;

sockaddr_in6 create_any_address(int port);
sockaddr_in6 extract_address_from_acceptor_proto(const AcceptorProto &proto);

// A thread that accepts new connections on a given socket,
// and hands them off to the server pool.
class Acceptor : public Thread {
public:
	Acceptor(int server_sock, const sockaddr_in6 &addr);

	// Serialization/deserialization.
	Acceptor(const AcceptorProto &serialized);
	AcceptorProto serialize() const;

	void close_socket();

private:
	virtual void do_work();

	int server_sock;
	sockaddr_in6 addr;
};

#endif  // !defined(_ACCEPTOR_H)
