/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef __CVC4__OPTIONS__SETS_H
#define __CVC4__OPTIONS__SETS_H

#include "options/options.h"




#define CVC4_OPTIONS__SETS__FOR_OPTION_HOLDER \
  setsExt__option_t::type setsExt;\
  bool setsExt__setByUser__; \
  setsInferAsLemmas__option_t::type setsInferAsLemmas;\
  bool setsInferAsLemmas__setByUser__; \
  setsProxyLemmas__option_t::type setsProxyLemmas;\
  bool setsProxyLemmas__setByUser__; \
  setsRelEager__option_t::type setsRelEager;\
  bool setsRelEager__setByUser__;


namespace CVC4 {

namespace options {

extern struct CVC4_PUBLIC setsExt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} setsExt CVC4_PUBLIC;
extern struct CVC4_PUBLIC setsInferAsLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} setsInferAsLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC setsProxyLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} setsProxyLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC setsRelEager__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} setsRelEager CVC4_PUBLIC;


}  // namespace options

template <> const options::setsExt__option_t::type& Options::operator[](
    options::setsExt__option_t) const;
template <> bool Options::wasSetByUser(options::setsExt__option_t) const;
template <> void Options::assignBool(
    options::setsExt__option_t,
    std::string option,
    bool value);
template <> const options::setsInferAsLemmas__option_t::type& Options::operator[](
    options::setsInferAsLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::setsInferAsLemmas__option_t) const;
template <> void Options::assignBool(
    options::setsInferAsLemmas__option_t,
    std::string option,
    bool value);
template <> const options::setsProxyLemmas__option_t::type& Options::operator[](
    options::setsProxyLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::setsProxyLemmas__option_t) const;
template <> void Options::assignBool(
    options::setsProxyLemmas__option_t,
    std::string option,
    bool value);
template <> const options::setsRelEager__option_t::type& Options::operator[](
    options::setsRelEager__option_t) const;
template <> bool Options::wasSetByUser(options::setsRelEager__option_t) const;
template <> void Options::assignBool(
    options::setsRelEager__option_t,
    std::string option,
    bool value);


namespace options {

inline setsExt__option_t::type setsExt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool setsExt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline setsInferAsLemmas__option_t::type setsInferAsLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool setsInferAsLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline setsProxyLemmas__option_t::type setsProxyLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool setsProxyLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline setsRelEager__option_t::type setsRelEager__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool setsRelEager__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}


}  // namespace options
}  // namespace CVC4

#endif /* __CVC4__OPTIONS__SETS_H */
