; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple powerpc-ibm-aix-xcoff -stop-after=machine-cp -mcpu=pwr7 \
; RUN:  -mattr=-altivec -verify-machineinstrs < %s | \
; RUN: FileCheck --check-prefix=32BIT %s

; RUN: llc -mtriple powerpc64-ibm-aix-xcoff -stop-after=machine-cp -mcpu=pwr7 \
; RUN:  -mattr=-altivec -verify-machineinstrs < %s | \
; RUN: FileCheck --check-prefix=64BIT %s

%struct.vec_struct = type { <4 x i32> }

; Function Attrs: norecurse nounwind readonly
define i32 @vec_struct_test(i32 %i, ptr nocapture readonly byval(%struct.vec_struct) align 16 %vs) {
  ; 32BIT-LABEL: name: vec_struct_test
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r5, $r6, $r7, $r8
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW killed renamable $r7, 8, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 8, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r6, 4, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 4)
  ; 32BIT-NEXT:   STW renamable $r5, 0, %fixed-stack.0 :: (store (s32) into %fixed-stack.0, align 16)
  ; 32BIT-NEXT:   STW killed renamable $r8, 12, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 12)
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r5, killed renamable $r3
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: vec_struct_test
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x5, $x6
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STD renamable $x5, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0, align 16)
  ; 64BIT-NEXT:   STD killed renamable $x6, 8, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 8)
  ; 64BIT-NEXT:   renamable $x4 = RLDICL killed renamable $x5, 32, 32
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 renamable $r4, renamable $r3, implicit killed $x3, implicit killed $x4, implicit-def $x3
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %vsi = getelementptr inbounds i8, ptr %vs, i32 0
  %0 = load <4 x i32>, ptr %vsi, align 16
  %vecext = extractelement <4 x i32> %0, i32 0
  %add = add nsw i32 %vecext, %i
  ret i32 %add
}
