# MLIR Maintainers

This file is a list of the
[maintainers](https://llvm.org/docs/DeveloperPolicy.html#maintainers) for MLIR.

The following people are the active maintainers for the project. For the sake of
simplicity, responsibility areas are subdivided into broad categories, which are
further subdivided into individual components, such as dialects. Please reach
out to them for code reviews, questions about their area of expertise, or other
assistance.

## Core

Core components of MLIR, including core IR, analyses and rewriters, fundamental
dialects, build system and language bindings.

- Alex Zinenko \
  ftynse@gmail.com (email),
  [@ftynse](https://github.com/ftynse) (GitHub),
  ftynse (Discourse)
- Jacques Pienaar \
  jpienaar@google.com (email),
  [@jpienaar](https://github.com/jpienaar) (GitHub),
  jpienaar (Discourse)
- Mehdi Amini \
  joker.eph@gmail.com (email),
  [@joker-eph](https://github.com/joker-eph) (GitHub),
  mehdi_amini (Discourse)

## Egress

MLIR components pertaining to egress flows from MLIR, in particular to LLVM IR.

- Matthias Springer \
  me@m-sp.org (email),
  [@matthias-springer](https://github.com/matthias-springer) (GitHub),
  matthias-springer (Discourse)
- Andrzej Warzynski \
  andrzej.warzynski@arm.com (email),
  [@banach-space](https://github.com/banach-space) (GitHub),
  banach-space (Discourse)
- Tobias Gysi \
  tobias.gysi@nextsilicon.com (email),
  [@gysit](https://github.com/gysit) (GitHub),
  gysit (Discourse)

## Tensor Compiler

MLIR components specific to construction of compilers for tensor algebra, in
particular for machine learning compilers.

- Renato Golin \
  rengolin@gmail.com (email),
  [@rengolin](https://github.com/rengolin) (GitHub),
  rengolin (Discourse)
- Jacques Pienaar \
  jpienaar@google.com (email),
  [@jpienaar](https://github.com/jpienaar) (GitHub),
  jpienaar (Discourse)
- Andrzej Warzynski \
  andrzej.warzynski@arm.com (email),
  [@banach-space](https://github.com/banach-space) (GitHub),
  banach-space (Discourse)
