# Largest Contentful Paint Changes in M86

## Changes in Chrome 86
Prior to Chrome 86, there was a [bug](https://bugs.chromium.org/p/chromium/issues/detail?id=1092473)
in Largest Contentful Paint on some pages where the largest contentful element
initially has opacity:0. The bug was fixed in Chrome 86. The source code of the
change can be seen [here](https://chromium-review.googlesource.com/c/chromium/src/+/2316788).

## How does this affect a site's metrics?

This change only affects metrics for a very small amount of sites. Generally
sites whose largest contentful elements are opacity:0 initially are using A/B
testing frameworks which initially clear the page before displaying the correct
content. Sites using this technique will now see a longer LCP, reflecting the
time until the largest contentful paint is visible to the user, instead of the
time it is loaded in the DOM but invisible.

We do not see an impact from this change in our overall metrics, so we believe
the effect on most sites will be minimal.

## When were users affected?

Most users were updated to Chrome 86 the week of October 5, 2020.
